/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.api;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.friends.commands.Friends;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.SubCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public abstract class TopCommand<T extends SubCommand>
extends Command
implements TabExecutor {
    protected final ArrayList<T> subCommands = new ArrayList();
    private final String PREFIX;
    private final Set<UUID> mutex = new HashSet<UUID>();

    protected TopCommand(String[] pCommandNames, String pPermission, String pPrefix) {
        super(pCommandNames[0], pPermission, pCommandNames);
        this.PREFIX = pPrefix;
    }

    public static boolean isPlayer(CommandSender pCommandSender) {
        if (!(pCommandSender instanceof ProxiedPlayer)) {
            Main.getInstance().reload();
            pCommandSender.sendMessage(Friends.getInstance().getPrefix() + "Party and Friends was reloaded. Anyway it is recommended to restart the bungeecord completely because it can be that not all features were reloaded/were right reloaded.");
            return false;
        }
        return true;
    }

    public void execute(CommandSender pCommandSender, String[] args) {
        if (TopCommand.isPlayer(pCommandSender)) {
            ProxiedPlayer player = (ProxiedPlayer)pCommandSender;
            UUID uuid = player.getUniqueId();
            if (this.mutex.contains(uuid)) {
                return;
            }
            this.mutex.add(uuid);
            BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> {
                try {
                    if (!this.isDisabledServer(player)) {
                        this.onCommand(PAFPlayerManager.getInstance().getPlayer((ProxiedPlayer)pCommandSender), args);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    this.mutex.remove(uuid);
                }
            });
        }
    }

    private boolean isDisabledServer(ProxiedPlayer pPlayer) {
        if (Main.getInstance().getGeneralConfig().getStringList("General.DisabledServers").contains(pPlayer.getServer().getInfo().getName())) {
            pPlayer.sendMessage(Main.getInstance().getMessages().getString("General.DisabledServer"));
            return true;
        }
        return false;
    }

    protected abstract void onCommand(OnlinePAFPlayer var1, String[] var2);

    public void addCommand(T pCommand) {
        this.subCommands.add(pCommand);
        this.sort();
    }

    protected void sort() {
        Collections.sort(this.subCommands);
    }

    public T getSubCommand(Class<? extends SubCommand> pClass) {
        for (SubCommand subCommand : this.subCommands) {
            if (!subCommand.getClass().equals(pClass)) continue;
            return (T)subCommand;
        }
        return null;
    }

    public String getPrefix() {
        return this.PREFIX;
    }

    @Deprecated
    public void tabComplete(TabCompleteEvent pEvent) {
    }

    protected List<String> playerComplete(String[] input) {
        return Collections.emptyList();
    }

    public List<String> onTabComplete(CommandSender commandSender, String[] strings) {
        return Collections.emptyList();
    }
}

