/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.api.party;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.party.LeftPartyEvent;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.abstractcommands.PartySubCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.party.command.PartyCommand;
import de.simonsator.partyandfriends.party.subcommand.Join;
import de.simonsator.partyandfriends.party.subcommand.PartyDenySubCommand;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public abstract class PlayerParty {
    private final String JOIN_COMMAND_NAME = " " + ((PartySubCommand)PartyCommand.getInstance().getSubCommand(Join.class)).getCommandName() + " ";
    private final String DENY_COMMAND_NAME;
    private final Matcher acceptInviteMatcher = PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Invite.AcceptInvite"));
    private final Matcher denyInviteMatcher = PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Invite.DeclineInvite"));

    public PlayerParty() {
        PartySubCommand denyCommand = (PartySubCommand)PartyCommand.getInstance().getSubCommand(PartyDenySubCommand.class);
        this.DENY_COMMAND_NAME = denyCommand != null ? " " + denyCommand.getCommandName() + " " : null;
    }

    public abstract boolean isLeader(PAFPlayer var1);

    public boolean isLeader(OnlinePAFPlayer player) {
        return this.isLeader((PAFPlayer)player);
    }

    public abstract boolean isBanned(PAFPlayer var1);

    public abstract void setBanned(PAFPlayer var1, boolean var2);

    public abstract boolean isPrivate();

    public abstract void setPrivateState(boolean var1);

    public boolean isInParty(OnlinePAFPlayer pPlayer) {
        return this.isAMember(pPlayer) || pPlayer.getUniqueId().equals(this.getLeader().getUniqueId());
    }

    protected abstract boolean isAMember(OnlinePAFPlayer var1);

    protected abstract List<UUID> getInvited();

    public boolean isNobodyInvited() {
        return this.getInvited().isEmpty();
    }

    public abstract OnlinePAFPlayer getLeader();

    public abstract void setLeader(OnlinePAFPlayer var1);

    public List<OnlinePAFPlayer> getAllPlayers() {
        List<OnlinePAFPlayer> allPlayers = this.getPlayers();
        OnlinePAFPlayer leader = this.getLeader();
        if (leader != null) {
            allPlayers.add(leader);
        }
        return allPlayers;
    }

    private void removePlayer(PAFPlayer pPlayer) {
        this.removePlayerSilent(pPlayer);
        this.sendMessage(PartyCommand.getInstance().getPrefix() + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.General.PlayerHasLeftTheParty")).replaceAll(Matcher.quoteReplacement(pPlayer.getDisplayName())));
    }

    protected abstract void removePlayerSilent(PAFPlayer var1);

    public abstract List<OnlinePAFPlayer> getPlayers();

    public abstract boolean addPlayer(OnlinePAFPlayer var1);

    public void leaveParty(OnlinePAFPlayer pPlayer) {
        this.leaveParty((PAFPlayer)pPlayer);
    }

    public void leaveParty(PAFPlayer pPlayer) {
        this.removePlayer(pPlayer);
        boolean needsNewLeader = this.needsNewLeader(pPlayer);
        BukkitBungeeAdapter.getInstance().callEvent((Object)new LeftPartyEvent(this, pPlayer));
        if (this.deleteParty()) {
            return;
        }
        if (needsNewLeader) {
            this.findNewLeader();
        }
    }

    public void kickPlayer(OnlinePAFPlayer pPlayer) {
        this.removePlayerSilent(pPlayer);
        pPlayer.sendMessage(Main.getInstance().getMessages().get(PartyCommand.getInstance().getPrefix(), "Party.Command.Kick.KickedPlayerOutOfThePartyKickedPlayer"));
        this.sendMessage(PartyCommand.getInstance().getPrefix() + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Kick.KickedPlayerOutOfThePartyOthers")).replaceAll(Matcher.quoteReplacement(pPlayer.getDisplayName())));
        this.deleteParty();
    }

    public void invite(OnlinePAFPlayer pPlayer) {
        this.setBanned(pPlayer, false);
        OnlinePAFPlayer lLeader = this.getLeader();
        pPlayer.sendMessage(PartyCommand.getInstance().getPrefix() + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Invite.YouWereInvitedBY")).replaceAll(Matcher.quoteReplacement(lLeader.getDisplayName())));
        TextComponent acceptMessage = new TextComponent(this.acceptInviteMatcher.replaceAll(Matcher.quoteReplacement(lLeader.getName())));
        acceptMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + PartyCommand.getInstance().getName() + this.JOIN_COMMAND_NAME + lLeader.getName()));
        BaseComponent[] clickHereMessage = new TextComponent(TextComponent.fromLegacyText((String)Main.getInstance().getMessages().getString("Party.Command.Invite.AcceptInviteHOVER"))).getExtra().toArray(new BaseComponent[0]);
        acceptMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, clickHereMessage));
        pPlayer.sendPacket(acceptMessage);
        if (this.DENY_COMMAND_NAME != null) {
            TextComponent denyMessage = new TextComponent(this.denyInviteMatcher.replaceAll(Matcher.quoteReplacement(lLeader.getName())));
            denyMessage.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/" + PartyCommand.getInstance().getName() + this.DENY_COMMAND_NAME + lLeader.getName()));
            clickHereMessage = new TextComponent(TextComponent.fromLegacyText((String)Main.getInstance().getMessages().getString("Party.Command.Invite.DeclineInviteHOVER"))).getExtra().toArray(new BaseComponent[0]);
            denyMessage.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, clickHereMessage));
            pPlayer.sendPacket(denyMessage);
        }
        if (!this.isPrivate()) {
            return;
        }
        this.addToInvited(pPlayer);
        PlayerParty party = this;
        BukkitBungeeAdapter.getInstance().schedule(Main.getInstance(), () -> {
            if (this.isInvited(pPlayer)) {
                this.removeFromInvited(pPlayer);
                OnlinePAFPlayer lLeader1 = this.getLeader();
                if (lLeader1 == null) {
                    return;
                }
                pPlayer.sendMessage(PartyCommand.getInstance().getPrefix() + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Invite.InvitationTimedOutInvited")).replaceAll(Matcher.quoteReplacement(lLeader1.getDisplayName())));
                lLeader1.sendMessage(PartyCommand.getInstance().getPrefix() + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Invite.InvitationTimedOutLeader")).replaceAll(Matcher.quoteReplacement(pPlayer.getDisplayName())));
                if (this.isPartyEmpty()) {
                    lLeader1.sendMessage(PartyCommand.getInstance().getPrefix() + Main.getInstance().getMessages().getString("Party.Command.General.DissolvedPartyCauseOfNotEnoughPlayers"));
                    PartyManager.getInstance().deleteParty(party);
                }
            }
        }, PartyManager.getInstance().INVITATION_TIMEOUT_TIME);
    }

    public abstract void removeFromInvited(PAFPlayer var1);

    public void removeFromInvited(OnlinePAFPlayer pPlayer) {
        this.removeFromInvited((PAFPlayer)pPlayer);
    }

    protected abstract void addToInvited(OnlinePAFPlayer var1);

    public boolean isPartyEmpty() {
        return this.getPlayers().isEmpty() && this.isNobodyInvited();
    }

    public abstract int getInviteListSize();

    public boolean isInvited(OnlinePAFPlayer pPlayer) {
        return !this.isPrivate() || this.getInvited().contains(pPlayer.getUniqueId());
    }

    public void sendMessage(TextComponent pText) {
        for (OnlinePAFPlayer player : this.getAllPlayers()) {
            player.sendMessage(pText);
        }
    }

    public void sendMessage(String pText) {
        for (OnlinePAFPlayer player : this.getAllPlayers()) {
            player.sendMessage(pText);
        }
    }

    private boolean deleteParty() {
        int partyMemberCount = this.getAllPlayers().size();
        if (partyMemberCount < 2 && this.isPrivate() || partyMemberCount == 0) {
            this.sendMessage(PartyCommand.getInstance().getPrefix() + Main.getInstance().getMessages().getString("Party.Command.General.DissolvedPartyCauseOfNotEnoughPlayers"));
            PartyManager.getInstance().deleteParty(this);
            for (OnlinePAFPlayer player : this.getAllPlayers()) {
                this.removePlayerSilent(player);
            }
            return true;
        }
        return false;
    }

    protected abstract boolean needsNewLeader(PAFPlayer var1);

    protected abstract void findNewLeader();
}

