/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.api.party.abstractcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.api.party.abstractcommands.PartySubCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.List;
import java.util.regex.Matcher;

public abstract class LeaderNeededCommand
extends PartySubCommand {
    protected LeaderNeededCommand(String[] pCommands, int pPriority, String pHelpText) {
        super(pCommands, pPriority, pHelpText);
    }

    public LeaderNeededCommand(List<String> pCommands, int pPriority, String pHelpText, String pPermission) {
        super(pCommands, pPriority, pHelpText, pPermission);
    }

    @Override
    public boolean hasAccess(int pPermissionHeight) {
        return pPermissionHeight == 2;
    }

    protected boolean checkIsInParty(OnlinePAFPlayer pPlayer, PAFPlayer pSearched, PlayerParty pParty, String[] args) {
        if (!pSearched.isOnline()) {
            pPlayer.sendMessage(this.PREFIX + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.General.ErrorGivenPlayerIsNotInTheParty")).replaceAll(Matcher.quoteReplacement(args[0])));
            return false;
        }
        if (!pParty.isInParty((OnlinePAFPlayer)pSearched)) {
            pPlayer.sendMessage(this.PREFIX + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.General.ErrorGivenPlayerIsNotInTheParty")).replaceAll(Matcher.quoteReplacement(args[0])));
            return false;
        }
        if (pSearched.equals(pPlayer)) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Leader.SenderEqualsGivenPlayer"));
            return false;
        }
        return true;
    }

    protected boolean standardCheck(OnlinePAFPlayer pPlayer, PlayerParty pParty, String[] args) {
        if (!this.isPlayerGiven(pPlayer, args)) {
            return false;
        }
        if (!this.isInParty(pPlayer, pParty)) {
            return false;
        }
        if (!pParty.isLeader(pPlayer)) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.General.ErrorNotPartyLeader"));
            return false;
        }
        return true;
    }
}

