/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.api.party.abstractcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.api.party.abstractcommands.PartySubCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public abstract class PartyJoinInviteSubCommand
extends PartySubCommand {
    private final Matcher TOO_MANY_PLAYERS_IN_PARTY_MATCHER;
    private final int DEFAULT_MAX_PLAYERS_PER_PARTY;
    private static List<MaxPlayerPermissionCollection> maxPlayerPermissionCollections = null;

    public PartyJoinInviteSubCommand(List<String> pCommands, int pPriority, String pHelpText, String pPermission, String pMaxPlayersInPartyMessage) {
        super(pCommands, pPriority, pHelpText, pPermission);
        ConfigurationCreator config = Main.getInstance().getGeneralConfig();
        this.DEFAULT_MAX_PLAYERS_PER_PARTY = config.getInt("Party.MaxPlayersPerParty.Default");
        this.TOO_MANY_PLAYERS_IN_PARTY_MATCHER = PatterCollection.MAX_PLAYERS_IN_PARTY_PATTERN.matcher(pMaxPlayersInPartyMessage);
        if (this.DEFAULT_MAX_PLAYERS_PER_PARTY != 0 && maxPlayerPermissionCollections == null) {
            maxPlayerPermissionCollections = new ArrayList<MaxPlayerPermissionCollection>();
            for (String key : config.getSectionKeys("Party.MaxPlayersPerParty.AddSlotsPermissions")) {
                maxPlayerPermissionCollections.add(new MaxPlayerPermissionCollection(config.getInt("Party.MaxPlayersPerParty.AddSlotsPermissions." + key + ".SlotsToAdd"), config.getString("Party.MaxPlayersPerParty.AddSlotsPermissions." + key + ".Permission")));
            }
        }
    }

    protected boolean canInvite(OnlinePAFPlayer pPartyLeader, PlayerParty pParty, OnlinePAFPlayer pMessageReceiver) {
        int maxPlayersForThisParty;
        if (!pPartyLeader.getPlayer().hasPermission(Main.getInstance().getGeneralConfig().getString("Party.MaxPlayersPerParty.NoLimitPermission")) && this.DEFAULT_MAX_PLAYERS_PER_PARTY > 1 && (maxPlayersForThisParty = this.calculateMaxPlayersForParty(pPartyLeader, pParty)) < pParty.getAllPlayers().size() + pParty.getInviteListSize() + 1) {
            pMessageReceiver.sendMessage(this.PREFIX + this.TOO_MANY_PLAYERS_IN_PARTY_MATCHER.replaceAll(Matcher.quoteReplacement(maxPlayersForThisParty + "")));
            return false;
        }
        return true;
    }

    private int calculateMaxPlayersForParty(OnlinePAFPlayer pPlayer, PlayerParty party) {
        int maxPlayersInParty = this.DEFAULT_MAX_PLAYERS_PER_PARTY;
        for (MaxPlayerPermissionCollection maxPlayerPermissionCollection : maxPlayerPermissionCollections) {
            if (!pPlayer.hasPermission(maxPlayerPermissionCollection.PERMISSION)) continue;
            maxPlayersInParty += maxPlayerPermissionCollection.SLOTS_TO_ADD;
        }
        return maxPlayersInParty;
    }

    private static class MaxPlayerPermissionCollection {
        public final int SLOTS_TO_ADD;
        public final String PERMISSION;

        private MaxPlayerPermissionCollection(int pSlotsToAdd, String permission) {
            this.SLOTS_TO_ADD = pSlotsToAdd;
            this.PERMISSION = permission;
        }
    }
}

