/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.c3p0.v1.db.sql;

import de.simonsator.partyandfriends.c3p0.v2.log.MLevel;
import de.simonsator.partyandfriends.c3p0.v2.log.MLog;
import de.simonsator.partyandfriends.c3p0.v2.log.MLogger;
import java.sql.Connection;
import java.sql.SQLException;

public final class ConnectionUtils {
    private static final MLogger logger = MLog.getLogger(ConnectionUtils.class);

    public static boolean attemptClose(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
            return true;
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Connection close FAILED.", sQLException);
            }
            return false;
        }
    }

    public static boolean attemptRollback(Connection connection) {
        try {
            if (connection != null) {
                connection.rollback();
            }
            return true;
        }
        catch (SQLException sQLException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Rollback FAILED.", sQLException);
            }
            return false;
        }
    }

    private ConnectionUtils() {
    }
}

