/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.communication.sql;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.communication.sql.MySQLData;
import de.simonsator.partyandfriends.communication.sql.cache.LocalPlayerCache;
import de.simonsator.partyandfriends.communication.sql.cache.NoCache;
import de.simonsator.partyandfriends.communication.sql.cache.PlayerCache;
import de.simonsator.partyandfriends.communication.sql.pool.PoolData;
import de.simonsator.partyandfriends.communication.sql.pool.PoolSQLCommunication;
import de.simonsator.partyandfriends.utilities.disable.Disabler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class MySQL
extends PoolSQLCommunication {
    private final String TABLE_PREFIX;
    private final PlayerCache cache;

    public MySQL(MySQLData pMySQLData, PoolData pPoolData, Object pIgnore) throws SQLException {
        super(pMySQLData, pPoolData);
        this.TABLE_PREFIX = pMySQLData.TABLE_PREFIX;
        this.importDatabase();
        this.cache = pMySQLData.CACHE ? new LocalPlayerCache() : new NoCache();
        Disabler.getInstance().registerDeactivated(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UUID getUUID(int pPlayerID) {
        UUID uuid = this.cache.getUUID(pPlayerID);
        if (uuid != null) {
            return uuid;
        }
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_uuid, player_name from " + this.TABLE_PREFIX + "players WHERE player_id='" + pPlayerID + "' LIMIT 1");
            if (rs.next()) {
                uuid = UUID.fromString(rs.getString("player_uuid"));
                this.cache.add(rs.getString("player_name"), uuid, pPlayerID);
                UUID uUID = uuid;
                this.close(con, rs, stmt);
                return uUID;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDatabase() {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.TABLE_PREFIX + "players` (`player_id` INT(8) NOT NULL AUTO_INCREMENT, `player_name` VARCHAR(16) NOT NULL, `player_uuid` CHAR(38) NOT NULL, PRIMARY KEY (`player_id`));");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.TABLE_PREFIX + "last_player_wrote_to` (`player_id` INT(8) NOT NULL, `written_to_id` INT(8) NOT NULL, FOREIGN KEY (`player_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), FOREIGN KEY (`written_to_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), PRIMARY KEY (`player_id`));");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.TABLE_PREFIX + "friend_assignment` (`friend1_id` INT(8) NOT NULL, `friend2_id` INT(8) NOT NULL, FOREIGN KEY (`friend1_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), FOREIGN KEY (`friend2_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), CONSTRAINT `PK_" + this.TABLE_PREFIX + "friend_assignment` PRIMARY KEY (friend1_id,friend2_id));");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.TABLE_PREFIX + "settings` (`player_id` INT(8) NOT NULL, `settings_id` TINYINT(2) NOT NULL,  `settings_worth` TINYINT(1) NOT NULL, FOREIGN KEY (`player_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), CONSTRAINT `PK_" + this.TABLE_PREFIX + "settings` PRIMARY KEY (player_id,settings_id));");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS `" + this.TABLE_PREFIX + "friend_request_assignment` (`requester_id` INT(8) NOT NULL, `receiver_id` INT(8) NOT NULL, FOREIGN KEY (`requester_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), FOREIGN KEY (`receiver_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), CONSTRAINT `PK_" + this.TABLE_PREFIX + "friend_request_assignment` PRIMARY KEY (requester_id,receiver_id));");
            prepStmt.executeUpdate();
            prepStmt.close();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
        this.addColumnLastOnline();
        this.addForeignKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addForeignKeys() {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("ALTER TABLE `" + this.TABLE_PREFIX + "last_player_wrote_to` ADD FOREIGN KEY (`player_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), ADD FOREIGN KEY (`written_to_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), ADD PRIMARY KEY (`player_id`);");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("ALTER TABLE `" + this.TABLE_PREFIX + "friend_assignment` ADD FOREIGN KEY (`friend1_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), ADD FOREIGN KEY (`friend2_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), ADD CONSTRAINT `PK_" + this.TABLE_PREFIX + "friend_assignment` PRIMARY KEY (friend1_id,friend2_id);");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("ALTER TABLE `" + this.TABLE_PREFIX + "settings` ADD FOREIGN KEY (`player_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), ADD CONSTRAINT `PK_" + this.TABLE_PREFIX + "settings` PRIMARY KEY (player_id,settings_id);");
            prepStmt.executeUpdate();
            prepStmt.close();
            prepStmt = con.prepareStatement("ALTER TABLE `" + this.TABLE_PREFIX + "friend_request_assignment` ADD FOREIGN KEY (`receiver_id`) REFERENCES `" + this.TABLE_PREFIX + "players`(`player_id`), ADD CONSTRAINT `PK_" + this.TABLE_PREFIX + "friend_request_assignment` PRIMARY KEY (requester_id,receiver_id);");
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        catch (SQLException sQLException) {
            this.close(con, prepStmt);
        }
        catch (Throwable throwable) {
            this.close(con, prepStmt);
            throw throwable;
        }
        this.close(con, prepStmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumnLastOnline() {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("SHOW COLUMNS from " + this.TABLE_PREFIX + "players LIKE 'last_online'");
            if (!rs.next()) {
                prepStmt = con.prepareStatement("ALTER TABLE `" + this.TABLE_PREFIX + "players` ADD COLUMN `last_online` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP AFTER `player_uuid`");
                prepStmt.executeUpdate();
                prepStmt.close();
            }
            this.close(con, rs, stmt, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt, prepStmt);
        }
    }

    public int getPlayerID(ProxiedPlayer pPlayer) {
        if (BukkitBungeeAdapter.getInstance().isOnlineMode()) {
            return this.getPlayerID(pPlayer.getUniqueId());
        }
        return this.getPlayerID(pPlayer.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerID(UUID pUUID) {
        Integer playerID = this.cache.getPlayerID(pUUID);
        if (playerID != null) {
            return playerID;
        }
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_id, player_name from " + this.TABLE_PREFIX + "players WHERE player_uuid='" + pUUID + "' LIMIT 1");
            if (rs.next()) {
                playerID = rs.getInt("player_id");
                this.cache.add(rs.getString("player_name"), pUUID, playerID);
                int n = playerID;
                this.close(con, rs, stmt);
                return n;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPlayerID(String pPlayerName) {
        Integer playerID = this.cache.getPlayerID(pPlayerName);
        if (playerID != null) {
            return playerID;
        }
        Connection con = this.getConnection();
        ResultSet rs = null;
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("select player_id, player_uuid from " + this.TABLE_PREFIX + "players WHERE player_name=? LIMIT 1");
            prepStmt.setString(1, pPlayerName);
            rs = prepStmt.executeQuery();
            if (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("player_uuid"));
                playerID = rs.getInt("player_id");
                this.cache.add(pPlayerName, uuid, playerID);
                int n = playerID;
                this.close(con, rs, (Statement)prepStmt);
                return n;
            }
            this.close(con, rs, (Statement)prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, prepStmt);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int firstJoin(ProxiedPlayer pPlayer) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        int id = 0;
        try {
            prepStmt = con.prepareStatement("insert into  " + this.TABLE_PREFIX + "players (player_name, player_uuid, last_online) values (?, ?, ?)", 1);
            prepStmt.setString(1, pPlayer.getName());
            prepStmt.setString(2, pPlayer.getUniqueId().toString());
            prepStmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
            prepStmt.executeUpdate();
            ResultSet rs = prepStmt.getGeneratedKeys();
            if (rs.next()) {
                id = rs.getInt(1);
                this.cache.add(pPlayer.getName(), pPlayer.getUniqueId(), id);
                rs.close();
                this.close(con, prepStmt);
                this.setStandardSettings(id);
            } else {
                rs.close();
            }
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
        return id;
    }

    private void setStandardSettings(int pPlayerID) {
        this.setSetting(pPlayerID, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getFriends(int pPlayerID) {
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        LinkedList<Integer> list = new LinkedList<Integer>();
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select friend2_id, friend1_id from " + this.TABLE_PREFIX + "friend_assignment WHERE friend1_id='" + pPlayerID + "' OR friend2_id='" + pPlayerID + "'");
            while (rs.next()) {
                int friend1 = rs.getInt("friend1_id");
                int friend2 = rs.getInt("friend2_id");
                if (friend1 == pPlayerID) {
                    list.add(friend2);
                    continue;
                }
                list.add(friend1);
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName(int pPlayerID) {
        String playerName = this.cache.getName(pPlayerID);
        if (playerName != null) {
            return playerName;
        }
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select player_name, player_uuid from " + this.TABLE_PREFIX + "players WHERE player_id='" + pPlayerID + "' LIMIT 1");
            if (rs.next()) {
                playerName = rs.getString("player_name");
                this.cache.add(playerName, UUID.fromString(rs.getString("player_uuid")), pPlayerID);
                String string = playerName;
                this.close(con, rs, stmt);
                return string;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlayerName(int pPlayerID, String pNewPlayerName) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("UPDATE " + this.TABLE_PREFIX + "players set player_name=? WHERE player_id='" + pPlayerID + "' LIMIT 1");
            prepStmt.setString(1, pNewPlayerName);
            prepStmt.executeUpdate();
            this.cache.updateName(pPlayerID, pNewPlayerName);
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUUID(int pPlayerID, UUID pNewUUID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("UPDATE " + this.TABLE_PREFIX + "players set player_uuid='" + pNewUUID + "' WHERE player_id='" + pPlayerID + "' LIMIT 1");
            prepStmt.executeUpdate();
            this.cache.updateUUID(pPlayerID, pNewUUID);
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasRequestFrom(int pReceiver, int pRequester) {
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select requester_id from " + this.TABLE_PREFIX + "friend_request_assignment WHERE receiver_id='" + pReceiver + "' AND requester_id='" + pRequester + "' LIMIT 1");
            if (rs.next()) {
                boolean bl = true;
                this.close(con, rs, stmt);
                return bl;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Integer> getRequests(int pPlayerID) {
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Integer> requests = new ArrayList<Integer>();
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select requester_id from " + this.TABLE_PREFIX + "friend_request_assignment WHERE receiver_id='" + pPlayerID + "'");
            while (rs.next()) {
                requests.add(rs.getInt("requester_id"));
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFriendCount(int pPlayerId) {
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select COUNT(requester_id) AS requestCount from " + this.TABLE_PREFIX + "friend_request_assignment WHERE receiver_id='" + pPlayerId + "' GROUP BY receiver_id");
            if (rs.next()) {
                int n = rs.getInt("requestCount");
                this.close(con, rs, stmt);
                return n;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFriend(int pIDRequester, int pIDReceiver) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("insert into " + this.TABLE_PREFIX + "friend_assignment values (?, ?)");
            prepStmt.setInt(1, pIDRequester);
            prepStmt.setInt(2, pIDReceiver);
            prepStmt.executeUpdate();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void denyRequest(int pReceiverSender, int pRequesterID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.TABLE_PREFIX + "friend_request_assignment WHERE requester_id = '" + pRequesterID + "' AND receiver_id='" + pReceiverSender + "' Limit 1");
            prepStmt.execute();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFriend(int pFriend1ID, int pFriend2ID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.TABLE_PREFIX + "friend_assignment WHERE (friend1_id = '" + pFriend1ID + "' AND friend2_id='" + pFriend2ID + "') OR (friend1_id = '" + pFriend2ID + "' AND friend2_id='" + pFriend1ID + "') Limit 1");
            prepStmt.execute();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFriendRequest(int pSenderID, int pQueryID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("insert into  " + this.TABLE_PREFIX + "friend_request_assignment values (?, ?)");
            prepStmt.setInt(1, pSenderID);
            prepStmt.setInt(2, pQueryID);
            prepStmt.executeUpdate();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    public int changeSettingsWorth(int pPlayerID, int pSettingsID) {
        int worth = this.getSettingsWorth(pPlayerID, pSettingsID);
        worth = worth == 1 ? 0 : 1;
        this.setSetting(pPlayerID, pSettingsID, worth);
        return worth;
    }

    @Deprecated
    public boolean isAFriendOf(ProxiedPlayer pPlayer1, ProxiedPlayer pPlayer2) {
        return this.isAFriendOf(this.getPlayerID(pPlayer1), this.getPlayerID(pPlayer2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSettingsWorth(int pPlayerID, int pSettingsID) {
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select settings_worth from " + this.TABLE_PREFIX + "settings WHERE player_id='" + pPlayerID + "' AND settings_id='" + pSettingsID + "' LIMIT 1");
            if (rs.next()) {
                int n = rs.getInt("settings_worth");
                this.close(con, rs, stmt);
                return n;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSetting(int pPlayerID, int pSettingsID, int pNewWorth) {
        if (pNewWorth == 0) {
            this.removeSetting(pPlayerID, pSettingsID);
        } else {
            Connection con = this.getConnection();
            PreparedStatement prepStmt = null;
            try {
                prepStmt = con.prepareStatement("insert into  " + this.TABLE_PREFIX + "settings values (?, ?, ?) ON DUPLICATE KEY UPDATE settings_worth=?");
                prepStmt.setInt(1, pPlayerID);
                prepStmt.setInt(2, pSettingsID);
                prepStmt.setInt(3, pNewWorth);
                prepStmt.setInt(4, pNewWorth);
                prepStmt.executeUpdate();
                this.close(con, prepStmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                this.close(con, prepStmt);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSetting(int pPlayerID, int pSettingsID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM  " + this.TABLE_PREFIX + "settings WHERE player_id = '" + pPlayerID + "' AND settings_id='" + pSettingsID + "' Limit 1");
            prepStmt.execute();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAFriendOf(int pPlayerID1, int pPlayerID2) {
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("Select friend1_id FROM " + this.TABLE_PREFIX + "friend_assignment WHERE (friend1_id = '" + pPlayerID1 + "' AND friend2_id='" + pPlayerID2 + "') OR (friend1_id = '" + pPlayerID2 + "' AND friend2_id='" + pPlayerID1 + "') LIMIT 1");
            if (rs.next()) {
                boolean bl = true;
                this.close(con, rs, stmt);
                return bl;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLastPlayerWroteTo(int pID) {
        block7: {
            int n;
            Connection con = this.getConnection();
            Statement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.createStatement();
                rs = stmt.executeQuery("select written_to_id from " + this.TABLE_PREFIX + "last_player_wrote_to WHERE player_id='" + pID + "' LIMIT 1");
                if (rs.next()) {
                    int n2 = rs.getInt("written_to_id");
                    this.close(con, rs, stmt);
                    return n2;
                }
                n = 0;
                this.close(con, rs, stmt);
            }
            catch (SQLException e) {
                e.printStackTrace();
                break block7;
            }
            finally {
                this.close(con, rs, stmt);
            }
            return n;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLastPlayerWroteTo(int pPlayerID, int pLastWroteTo) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("insert into " + this.TABLE_PREFIX + "last_player_wrote_to values (?, ?) ON DUPLICATE KEY UPDATE written_to_id=?;");
            prepStmt.setInt(1, pPlayerID);
            prepStmt.setInt(2, pLastWroteTo);
            prepStmt.setInt(3, pLastWroteTo);
            prepStmt.addBatch();
            prepStmt.setInt(1, pLastWroteTo);
            prepStmt.setInt(2, pPlayerID);
            prepStmt.setInt(3, pPlayerID);
            prepStmt.addBatch();
            prepStmt.executeBatch();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLastOnline(int pPlayerID) {
        Connection con = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            rs = stmt.executeQuery("select last_online from " + this.TABLE_PREFIX + "players WHERE player_id='" + pPlayerID + "' LIMIT 1");
            if (rs.next()) {
                Timestamp timestamp = rs.getTimestamp("last_online");
                this.close(con, rs, stmt);
                return timestamp;
            }
            this.close(con, rs, stmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, rs, stmt);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLastOnline(int pPlayerID) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("UPDATE " + this.TABLE_PREFIX + "players set last_online=now() WHERE player_id='" + pPlayerID + "' LIMIT 1");
            prepStmt.executeUpdate();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlayerEntry(int pPlayerId) {
        Connection con = this.getConnection();
        PreparedStatement prepStmt = null;
        try {
            prepStmt = con.prepareStatement("DELETE FROM " + this.TABLE_PREFIX + "friend_request_assignment WHERE requester_id = '" + pPlayerId + "' OR receiver_id='" + pPlayerId + "';");
            prepStmt.execute();
            prepStmt = con.prepareStatement("DELETE FROM " + this.TABLE_PREFIX + "friend_assignment WHERE friend1_id = '" + pPlayerId + "' OR friend2_id='" + pPlayerId + "';");
            prepStmt.execute();
            prepStmt = con.prepareStatement("DELETE FROM " + this.TABLE_PREFIX + "settings WHERE player_id='" + pPlayerId + "';");
            prepStmt.execute();
            prepStmt = con.prepareStatement("DELETE FROM " + this.TABLE_PREFIX + "last_player_wrote_to WHERE player_id='" + pPlayerId + "' OR written_to_id='" + pPlayerId + "';");
            prepStmt.execute();
            this.close(con, prepStmt);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            this.close(con, prepStmt);
        }
        this.cache.deletePlayer(pPlayerId);
    }
}

