/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.communication.sql;

import de.simonsator.partyandfriends.communication.sql.DBCommunication;
import de.simonsator.partyandfriends.communication.sql.MySQLData;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;

public abstract class SQLCommunication
extends DBCommunication {
    protected final String DATABASE;
    private final Properties connectionProperties;
    private String url;
    private Connection connection;

    protected SQLCommunication(String pDatabase, String pURL, String pUserName, String pPassword, boolean pUseSSL) {
        this.DATABASE = pDatabase;
        this.url = pURL;
        this.connectionProperties = new Properties();
        this.connectionProperties.setProperty("user", pUserName);
        this.connectionProperties.setProperty("password", pPassword);
        this.connectionProperties.setProperty("useSSL", pUseSSL + "");
        this.connection = this.createConnection();
    }

    @Deprecated
    protected SQLCommunication(String pDatabase, String pURL, String pUserName, String pPassword) {
        this.DATABASE = pDatabase;
        this.url = pURL;
        this.connectionProperties = new Properties();
        this.connectionProperties.setProperty("user", pUserName);
        this.connectionProperties.setProperty("password", pPassword);
        this.connection = this.createConnection();
    }

    protected SQLCommunication(MySQLData pMySQLData) {
        this.DATABASE = pMySQLData.DATABASE;
        this.url = "jdbc:mysql://" + pMySQLData.HOST + ":" + pMySQLData.PORT + "/";
        this.connectionProperties = new Properties();
        this.connectionProperties.setProperty("user", pMySQLData.USERNAME);
        this.connectionProperties.setProperty("password", pMySQLData.PASSWORD);
        this.connectionProperties.setProperty("useSSL", pMySQLData.USE_SSL + "");
        this.connectionProperties.setProperty("allowPublicKeyRetrieval", !pMySQLData.USE_SSL + "");
        Connection con = this.createConnection();
        try {
            PreparedStatement prepStmt = con.prepareStatement("CREATE DATABASE IF NOT EXISTS `" + this.DATABASE + "`");
            prepStmt.executeUpdate();
            prepStmt.close();
            con.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.url = this.url + pMySQLData.DATABASE;
        this.connection = this.createConnection();
    }

    protected Connection getConnection() {
        try {
            if (this.connection != null && this.connection.isValid(6)) {
                return this.connection;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.connection = this.createConnection();
        return this.connection;
    }

    private Connection createConnection() {
        try {
            this.closeConnection();
            Class.forName("com.mysql.jdbc.Driver");
            return DriverManager.getConnection(this.url, this.connectionProperties);
        }
        catch (ClassNotFoundException | SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null) {
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

