/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.communication.sql.cache;

import de.simonsator.partyandfriends.communication.sql.cache.PlayerCache;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class LocalPlayerCache
extends PlayerCache {
    private final Map<String, Integer> namePlayerID = new HashMap<String, Integer>();
    private final Map<UUID, Integer> uuidPlayerID = new HashMap<UUID, Integer>();
    private final Map<Integer, String> playerIDName = new HashMap<Integer, String>();
    private final Map<Integer, UUID> playerIDUUID = new HashMap<Integer, UUID>();

    @Override
    public void add(String pName, UUID pUUID, int pPlayerID) {
        this.namePlayerID.put(pName.toLowerCase(), pPlayerID);
        this.uuidPlayerID.put(pUUID, pPlayerID);
        this.playerIDName.put(pPlayerID, pName);
        this.playerIDUUID.put(pPlayerID, pUUID);
    }

    @Override
    public Integer getPlayerID(String pName) {
        return this.namePlayerID.get(pName.toLowerCase());
    }

    @Override
    public Integer getPlayerID(UUID pUUID) {
        return this.uuidPlayerID.get(pUUID);
    }

    @Override
    public String getName(int pID) {
        return this.playerIDName.get(pID);
    }

    @Override
    public UUID getUUID(int pID) {
        return this.playerIDUUID.get(pID);
    }

    @Override
    public void updateUUID(int pPlayerID, UUID pNewUUID) {
        UUID oldUUID = this.getUUID(pPlayerID);
        if (oldUUID != null) {
            this.uuidPlayerID.remove(oldUUID);
        }
        this.uuidPlayerID.put(pNewUUID, pPlayerID);
        this.playerIDUUID.put(pPlayerID, pNewUUID);
    }

    @Override
    public void updateName(int pPlayerID, String pNewPlayerName) {
        String oldName = this.getName(pPlayerID);
        if (oldName != null) {
            this.namePlayerID.remove(oldName);
        }
        this.namePlayerID.put(pNewPlayerName, pPlayerID);
        this.playerIDName.put(pPlayerID, pNewPlayerName);
    }

    @Override
    public void deletePlayer(int pPlayerID) {
        String playerName = this.playerIDName.remove(pPlayerID);
        UUID playerUUID = this.playerIDUUID.remove(pPlayerID);
        if (playerName != null) {
            this.namePlayerID.remove(playerName);
        }
        if (playerUUID != null) {
            this.uuidPlayerID.remove(playerUUID);
        }
    }
}

