/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.communication.sql.pool;

import de.simonsator.partyandfriends.c3p0.v2.c3p0.ComboPooledDataSource;
import de.simonsator.partyandfriends.communication.sql.DBCommunication;
import de.simonsator.partyandfriends.communication.sql.MySQLData;
import de.simonsator.partyandfriends.communication.sql.pool.PoolData;
import de.simonsator.partyandfriends.utilities.disable.Deactivated;
import de.simonsator.partyandfriends.utilities.disable.Disabler;
import java.beans.PropertyVetoException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class PoolSQLCommunication
extends DBCommunication
implements Deactivated {
    private final MySQLData MYSQL_DATA;
    private final PoolData POOL_DATA;
    private final Properties connectionProperties;
    private final ComboPooledDataSource cpds;

    public PoolSQLCommunication(MySQLData pMySQLData, PoolData pPoolData) throws SQLException {
        this.MYSQL_DATA = pMySQLData;
        this.POOL_DATA = pPoolData;
        this.connectionProperties = new Properties();
        this.connectionProperties.setProperty("user", this.MYSQL_DATA.USERNAME);
        this.connectionProperties.setProperty("password", this.MYSQL_DATA.PASSWORD);
        this.connectionProperties.setProperty("useSSL", pMySQLData.USE_SSL + "");
        this.connectionProperties.setProperty("allowPublicKeyRetrieval", !pMySQLData.USE_SSL + "");
        this.connectionProperties.setProperty("rewriteBatchedStatements", "true");
        this.createDatabase();
        this.cpds = this.createConnection();
        Disabler.getInstance().registerDeactivated(this);
    }

    private void createDatabase() throws SQLException {
        try {
            Class.forName("com.mysql.jdbc.Driver");
            Connection con = DriverManager.getConnection("jdbc:mysql://" + this.MYSQL_DATA.HOST + ":" + this.MYSQL_DATA.PORT, this.connectionProperties);
            PreparedStatement prepStmt = con.prepareStatement("CREATE DATABASE IF NOT EXISTS `" + this.getDatabase() + "`");
            prepStmt.executeUpdate();
            prepStmt.close();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    private ComboPooledDataSource createConnection() {
        try {
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setDriverClass("com.mysql.jdbc.Driver");
            cpds.setJdbcUrl("jdbc:mysql://" + this.MYSQL_DATA.HOST + ":" + this.MYSQL_DATA.PORT + "/" + this.MYSQL_DATA.DATABASE);
            cpds.setProperties(this.connectionProperties);
            cpds.setInitialPoolSize(this.POOL_DATA.INITIAL_POOL_SIZE);
            cpds.setMinPoolSize(this.POOL_DATA.MIN_POOL_SIZE);
            cpds.setMaxPoolSize(this.POOL_DATA.MAX_POOL_SIZE);
            cpds.setTestConnectionOnCheckin(this.POOL_DATA.TEST_CONNECTION_ON_CHECKIN);
            cpds.setIdleConnectionTestPeriod(this.POOL_DATA.IDLE_CONNECTION_TEST_PERIOD);
            return cpds;
        }
        catch (PropertyVetoException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void closeConnection() {
        if (this.cpds != null) {
            this.cpds.close();
        }
    }

    @Override
    public void onDisable() {
        this.closeConnection();
    }

    protected void close(Connection con, ResultSet rs, Statement stmt) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.close(rs, stmt);
    }

    protected void close(Connection con, ResultSet rs, Statement stmt, PreparedStatement prepStmt) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.close(rs, stmt, prepStmt);
    }

    protected void close(Connection con, PreparedStatement pPrepStmt) {
        try {
            if (con != null) {
                con.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.close(pPrepStmt);
    }

    public Connection getConnection() {
        try {
            return this.cpds.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getDatabase() {
        return this.MYSQL_DATA.DATABASE;
    }
}

