/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.friends.commands;

import de.simonsator.partyandfriends.api.TopCommand;
import de.simonsator.partyandfriends.api.friends.abstractcommands.FriendSubCommand;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.friends.subcommands.Accept;
import de.simonsator.partyandfriends.friends.subcommands.Add;
import de.simonsator.partyandfriends.friends.subcommands.Deny;
import de.simonsator.partyandfriends.friends.subcommands.FriendList;
import de.simonsator.partyandfriends.friends.subcommands.Jump;
import de.simonsator.partyandfriends.friends.subcommands.Message;
import de.simonsator.partyandfriends.friends.subcommands.Remove;
import de.simonsator.partyandfriends.friends.subcommands.Settings;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.ConfigurationCreator;
import java.util.List;

public class Friends
extends TopCommand<FriendSubCommand> {
    private static Friends instance;

    public Friends(List<String> pCommandNames, String pPrefix) {
        super(pCommandNames.toArray(new String[0]), Main.getInstance().getGeneralConfig().getString("Commands.Friends.TopCommands.Friend.Permissions"), pPrefix);
        instance = this;
        ConfigurationCreator config = Main.getInstance().getGeneralConfig();
        if (!config.getBoolean("Commands.Friends.SubCommands.List.Disabled")) {
            this.subCommands.add(new FriendList(config.getStringList("Commands.Friends.SubCommands.List.Names"), config.getInt("Commands.Friends.SubCommands.List.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.List"), config.getString("Commands.Friends.SubCommands.List.Permission")));
        }
        if (!config.getBoolean("Commands.Friends.SubCommands.MSG.Disabled")) {
            this.subCommands.add(new Message(config.getStringList("Commands.Friends.SubCommands.MSG.Names"), config.getInt("Commands.Friends.SubCommands.MSG.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.MSG"), config.getString("Commands.Friends.SubCommands.MSG.Permission")));
        }
        List<String> acceptCommandNames = config.getStringList("Commands.Friends.SubCommands.Accept.Names");
        this.subCommands.add(new Accept(acceptCommandNames, config.getInt("Commands.Friends.SubCommands.Accept.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.Accept"), config.getString("Commands.Friends.SubCommands.Accept.Permission")));
        this.subCommands.add(new Add(config.getStringList("Commands.Friends.SubCommands.Add.Names"), config.getInt("Commands.Friends.SubCommands.Add.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.ADD"), acceptCommandNames.get(0), config.getString("Commands.Friends.SubCommands.Add.Permission")));
        this.subCommands.add(new Deny(config.getStringList("Commands.Friends.SubCommands.Deny.Names"), config.getInt("Commands.Friends.SubCommands.Deny.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.Deny"), config.getString("Commands.Friends.SubCommands.Deny.Permission")));
        this.subCommands.add(new Remove(config.getStringList("Commands.Friends.SubCommands.Remove.Names"), config.getInt("Commands.Friends.SubCommands.Remove.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.Remove"), config.getString("Commands.Friends.SubCommands.Remove.Permission")));
        if (!config.getBoolean("Commands.Friends.SubCommands.Jump.Disabled")) {
            this.subCommands.add(new Jump(config.getStringList("Commands.Friends.SubCommands.Jump.Names"), config.getInt("Commands.Friends.SubCommands.Jump.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.Jump"), config.getString("Commands.Friends.SubCommands.Jump.Permission")));
        }
        if (!config.getBoolean("Commands.Friends.SubCommands.Settings.Disabled")) {
            this.subCommands.add(new Settings(config.getStringList("Commands.Friends.SubCommands.Settings.Names"), config.getInt("Commands.Friends.SubCommands.Jump.Priority"), Main.getInstance().getMessages().getString("Friends.CommandUsage.Settings"), config.getString("Commands.Friends.SubCommands.Settings.Permission")));
        }
        this.sort();
    }

    public static Friends getInstance() {
        return instance;
    }

    @Override
    protected void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        if (args.length == 0) {
            pPlayer.sendMessage(Main.getInstance().getMessages().getString("Friends.General.HelpBegin"));
            for (FriendSubCommand command : this.subCommands) {
                if (!command.hasPermission(pPlayer)) continue;
                command.printOutHelp(pPlayer, this.getName());
            }
            pPlayer.sendMessage(Main.getInstance().getMessages().getString("Friends.General.HelpEnd"));
            return;
        }
        for (FriendSubCommand command : this.subCommands) {
            if (!command.isApplicable(args[0])) continue;
            if (command.hasPermission(pPlayer)) {
                command.onCommand(pPlayer, args);
            } else {
                pPlayer.sendMessage(this.getPrefix() + Main.getInstance().getMessages().getString("Friends.General.NoPermission"));
            }
            return;
        }
        pPlayer.sendMessage(Main.getInstance().getMessages().get(this.getPrefix(), "Friends.General.CommandNotFound"));
    }
}

