/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.friends.commands;

import de.simonsator.partyandfriends.api.OnlyTopCommand;
import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.message.FriendOnlineMessageEvent;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.friends.commands.Friends;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.regex.Matcher;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.TextComponent;

public class MSG
extends OnlyTopCommand {
    private static MSG instance;
    private final String DEFAULT_MESSAGE_COLOR;
    private final boolean ALLOW_PLAYER_CHAT_FORMATTING;

    public MSG(String[] friendsAliasMsg, String pPrefix) {
        super(friendsAliasMsg, Main.getInstance().getGeneralConfig().getString("Commands.Friends.TopCommands.MSG.Permission"), pPrefix);
        instance = this;
        this.DEFAULT_MESSAGE_COLOR = PatterCollection.SPACE_PATTERN.matcher(Main.getInstance().getMessages().getString("Friends.Command.MSG.ColorOfMessage")).replaceAll("");
        this.ALLOW_PLAYER_CHAT_FORMATTING = Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.TopCommands.MSG.AllowPlayersToUseChatFormatting");
    }

    private static boolean playerExists(OnlinePAFPlayer pPlayer, PAFPlayer pPlayerQuery) {
        if (!pPlayerQuery.doesExist() || pPlayer.equals(pPlayerQuery)) {
            pPlayer.sendMessage(Friends.getInstance().getPrefix() + Main.getInstance().getMessages().getString("Friends.Command.MSG.CanNotWriteToHim"));
            return false;
        }
        return true;
    }

    public static MSG getInstance() {
        return instance;
    }

    @Override
    protected void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        this.send(pPlayer, args, 1);
    }

    public void send(OnlinePAFPlayer pPlayer, String[] args, int type) {
        int begin = 1;
        if (type == 1) {
            begin = 0;
        }
        if (!this.messageGiven(pPlayer, args, begin + 1)) {
            return;
        }
        PAFPlayer writtenTo = PAFPlayerManager.getInstance().getPlayer(args[begin]);
        if (!MSG.playerExists(pPlayer, writtenTo)) {
            return;
        }
        int n = 2;
        if (type == 1) {
            n = 1;
        }
        this.send(pPlayer, args, writtenTo, n);
    }

    void send(OnlinePAFPlayer pPlayer, String[] args, PAFPlayer pWrittenTo, int n) {
        if (!this.isFriendOf(pPlayer, pWrittenTo)) {
            return;
        }
        if (!this.allowsWriteTo(pPlayer, pWrittenTo)) {
            return;
        }
        if (this.isOffline(pPlayer, pWrittenTo, args, n)) {
            return;
        }
        FriendOnlineMessageEvent friendMessageEvent = new FriendOnlineMessageEvent((OnlinePAFPlayer)pWrittenTo, pPlayer, this.toMessageNoColor(args, n));
        BukkitBungeeAdapter.getInstance().callEvent((Object)friendMessageEvent);
        if (friendMessageEvent.isCancelled()) {
            return;
        }
        this.sendMessage(friendMessageEvent.getMessage(), (OnlinePAFPlayer)pWrittenTo, pPlayer);
        pPlayer.setLastPlayerWroteFrom(pWrittenTo);
    }

    boolean messageGiven(OnlinePAFPlayer pPlayer, String[] args, int n) {
        if (args.length <= n) {
            if (args.length != n) {
                pPlayer.sendMessage(this.getPrefix() + Main.getInstance().getMessages().getString("Friends.General.NoPlayerGiven"));
            } else {
                pPlayer.sendMessage(this.getPrefix() + Main.getInstance().getMessages().getString("Friends.Command.MSG.MessageMissing"));
            }
            if (Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.General.PrintOutHelpOnError")) {
                pPlayer.sendMessage(Main.getInstance().getMessages().getString("Friends.CommandUsage.MSG"));
            }
            return false;
        }
        return true;
    }

    private boolean isOffline(OnlinePAFPlayer pPlayer, PAFPlayer pQueryPlayer, String[] args, int n) {
        if (!pQueryPlayer.isOnline()) {
            pPlayer.sendMessage(this.getPrefix() + Main.getInstance().getMessages().getString("Friends.Command.MSG.CanNotWriteToHim"));
            return true;
        }
        return false;
    }

    private boolean allowsWriteTo(OnlinePAFPlayer pPlayer, PAFPlayer pQueryPlayer) {
        if (Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.SubCommands.Settings.Settings.PM.Enabled") && pQueryPlayer.getSettingsWorth(2) == 1) {
            pPlayer.sendMessage(this.getPrefix() + Main.getInstance().getMessages().getString("Friends.Command.MSG.CanNotWriteToHim"));
            return false;
        }
        return true;
    }

    private boolean isFriendOf(OnlinePAFPlayer pPlayer, PAFPlayer pQueryPlayer) {
        if (!pPlayer.isAFriendOf(pQueryPlayer) && !pPlayer.hasPermission(Main.getInstance().getGeneralConfig().getString("Commands.Friends.TopCommands.MSG.MSGNonFriendsPermission"))) {
            pPlayer.sendMessage(this.getPrefix() + Main.getInstance().getMessages().getString("Friends.Command.MSG.CanNotWriteToHim"));
            return false;
        }
        return true;
    }

    private void sendMessage(String pContent, OnlinePAFPlayer pPlayer1, OnlinePAFPlayer pPlayer2) {
        TextComponent formattedMessage = this.formatMessage(pContent, pPlayer2.getDisplayName(), pPlayer1.getDisplayName());
        this.sendMessage(formattedMessage, pPlayer1, pPlayer2.getName());
        this.sendMessage(formattedMessage, pPlayer2, pPlayer1.getName());
    }

    private TextComponent formatMessage(String pContent, String pSenderDisplayName, String pReceiverName) {
        if (this.ALLOW_PLAYER_CHAT_FORMATTING) {
            return new TextComponent(TextComponent.fromLegacyText((String)(this.getPrefix() + PatterCollection.CONTENT_PATTERN.matcher(PatterCollection.PLAYER_PATTERN.matcher(PatterCollection.SENDER_NAME_PATTERN.matcher(Main.getInstance().getMessages().getString("Friends.Command.MSG.SentMessage")).replaceAll(Matcher.quoteReplacement(pSenderDisplayName))).replaceAll(Matcher.quoteReplacement(pReceiverName))).replaceAll(Matcher.quoteReplacement(this.DEFAULT_MESSAGE_COLOR + ChatColor.translateAlternateColorCodes((char)'&', (String)pContent) + " \u00a7r")))));
        }
        return new TextComponent(this.getPrefix() + PatterCollection.CONTENT_PATTERN.matcher(PatterCollection.PLAYER_PATTERN.matcher(PatterCollection.SENDER_NAME_PATTERN.matcher(Main.getInstance().getMessages().getString("Friends.Command.MSG.SentMessage")).replaceAll(Matcher.quoteReplacement(pSenderDisplayName))).replaceAll(Matcher.quoteReplacement(pReceiverName))).replaceAll(Matcher.quoteReplacement(PatterCollection.SPACE_PATTERN.matcher(pContent).replaceAll(" " + this.DEFAULT_MESSAGE_COLOR))));
    }

    private void sendMessage(TextComponent pMessage, OnlinePAFPlayer pReceiver, String pSenderName) {
        pReceiver.sendPacket(pMessage);
    }

    private String toMessageNoColor(String[] args, int n) {
        StringBuilder content = new StringBuilder();
        while (n < args.length) {
            content.append(" ");
            content.append(args[n]);
            ++n;
        }
        return content.toString();
    }
}

