/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.friends.subcommands;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.command.JumpToFriendEvent;
import de.simonsator.partyandfriends.api.friends.ServerConnector;
import de.simonsator.partyandfriends.api.friends.abstractcommands.FriendSubCommand;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerClass;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;

public class Jump
extends FriendSubCommand {
    private final Set<ServerInfo> notCheckSameServer = new HashSet<ServerInfo>();

    public Jump(List<String> pCommands, int pPriority, String pHelp, String pPermission) {
        super(pCommands, pPriority, pHelp, pPermission);
    }

    @Deprecated
    public static void setServerConnector(ServerConnector pConnector) {
        PAFPlayerClass.setServerConnector(pConnector);
    }

    @Override
    public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        if (!this.isPlayerGiven(pPlayer, args)) {
            return;
        }
        PAFPlayer playerQuery = PAFPlayerManager.getInstance().getPlayer(args[1]);
        if (!this.isPlayerOnline(pPlayer, playerQuery)) {
            return;
        }
        OnlinePAFPlayer friend = (OnlinePAFPlayer)playerQuery;
        if (!this.isAFriendOf(pPlayer, friend, args)) {
            return;
        }
        ServerInfo toJoin = friend.getServer();
        if (!this.serverExists(pPlayer, toJoin)) {
            return;
        }
        if (!this.notCheckSameServer.contains(toJoin) && this.isAlreadyOnServer(pPlayer, toJoin)) {
            return;
        }
        if (!this.allowsJumps(pPlayer, friend)) {
            return;
        }
        if (this.isDisabled(pPlayer, toJoin)) {
            return;
        }
        JumpToFriendEvent event = new JumpToFriendEvent(pPlayer, friend, args, this);
        BukkitBungeeAdapter.getInstance().callEvent((Object)event);
        if (event.isCancelled()) {
            return;
        }
        if (!toJoin.equals(pPlayer.getServer())) {
            pPlayer.connect(toJoin);
        }
        pPlayer.sendMessage(this.PREFIX + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Friends.Command.Jump.JoinedTheServer")).replaceAll(Matcher.quoteReplacement(friend.getDisplayName())));
    }

    private boolean serverExists(OnlinePAFPlayer pPlayer, ServerInfo toJoin) {
        if (toJoin != null) {
            return true;
        }
        this.sendError(pPlayer, "Friends.Command.Jump.CanNotJump");
        return false;
    }

    private boolean allowsJumps(OnlinePAFPlayer pPlayer, OnlinePAFPlayer pQueryPlayer) {
        if (Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.SubCommands.Settings.Settings.Jump.Enabled") && pQueryPlayer.getSettingsWorth(4) == 1) {
            this.sendError(pPlayer, "Friends.Command.Jump.CanNotJump");
            return false;
        }
        return true;
    }

    private boolean isAlreadyOnServer(OnlinePAFPlayer pPlayer, ServerInfo pToJoin) {
        if (pToJoin.equals(pPlayer.getServer())) {
            this.sendError(pPlayer, "Friends.Command.Jump.AlreadyOnTheServer");
            return true;
        }
        return false;
    }

    private boolean isPlayerOnline(OnlinePAFPlayer pSender, PAFPlayer pQueryPlayer) {
        if (!pQueryPlayer.isOnline()) {
            this.sendError(pSender, new TextComponent(Main.getInstance().getMessages().getString("Friends.General.PlayerIsOffline").replace("[PLAYER]", pQueryPlayer.getDisplayName())));
            return false;
        }
        return true;
    }

    private boolean isDisabled(OnlinePAFPlayer pPlayer, ServerInfo pToJoin) {
        if (Main.getInstance().getGeneralConfig().getStringList("Commands.Friends.SubCommands.Jump.DisabledServers").contains(pToJoin.getName())) {
            this.sendError(pPlayer, "Friends.Command.Jump.CanNotJump");
            return true;
        }
        return false;
    }

    public void checkForSameServer(ServerInfo pServer) {
        this.notCheckSameServer.remove(pServer);
    }

    public void doNotCheckForSameServer(ServerInfo pServer) {
        this.notCheckSameServer.add(pServer);
    }
}

