/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.main;

import de.simonsator.partyandfriends.admin.commands.PAFAdminCommand;
import de.simonsator.partyandfriends.api.PAFExtension;
import de.simonsator.partyandfriends.api.PAFPluginBase;
import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.bungeecord.Metrics;
import de.simonsator.partyandfriends.communication.sql.MySQLData;
import de.simonsator.partyandfriends.communication.sql.pool.PoolData;
import de.simonsator.partyandfriends.friends.commands.Friends;
import de.simonsator.partyandfriends.friends.commands.MSG;
import de.simonsator.partyandfriends.friends.commands.Reply;
import de.simonsator.partyandfriends.main.BootErrorCommand;
import de.simonsator.partyandfriends.main.listener.JoinEvent;
import de.simonsator.partyandfriends.main.listener.PlayerDisconnectListener;
import de.simonsator.partyandfriends.main.listener.ServerSwitchListener;
import de.simonsator.partyandfriends.main.startup.error.BootErrorType;
import de.simonsator.partyandfriends.main.startup.error.ErrorReporter;
import de.simonsator.partyandfriends.pafplayers.manager.PAFPlayerManagerMySQL;
import de.simonsator.partyandfriends.pafplayers.mysql.PAFPlayerMySQL;
import de.simonsator.partyandfriends.party.command.PartyChat;
import de.simonsator.partyandfriends.party.command.PartyCommand;
import de.simonsator.partyandfriends.party.partymanager.LocalPartyManager;
import de.simonsator.partyandfriends.updatechecker.UpdateSearcher;
import de.simonsator.partyandfriends.utilities.ConfigLoader;
import de.simonsator.partyandfriends.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.utilities.Language;
import de.simonsator.partyandfriends.utilities.LanguageConfiguration;
import de.simonsator.partyandfriends.utilities.MessagesLoader;
import de.simonsator.partyandfriends.utilities.ServerDisplayNameCollection;
import de.simonsator.partyandfriends.utilities.StandardPermissionProvider;
import de.simonsator.partyandfriends.utilities.disable.Disabler;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

public class Main
extends PAFPluginBase
implements ErrorReporter {
    private static Main instance;
    private ConfigLoader config;
    private MessagesLoader messages = null;
    private String partyPrefix;
    private Language language;
    private Friends friendCommand;
    private final List<PAFExtension> pafExtensions = new ArrayList<PAFExtension>();

    public static Main getInstance() {
        return instance;
    }

    @Deprecated
    public static PartyManager getPartyManager() {
        return PartyManager.getInstance();
    }

    @Deprecated
    public static PAFPlayerManager getPlayerManager() {
        return PAFPlayerManager.getInstance();
    }

    public ConfigurationCreator getGeneralConfig() {
        return this.config;
    }

    public void onEnable() {
        instance = this;
        this.loadConfiguration();
        try {
            this.initPAFClasses();
            this.registerCommands();
            this.registerListeners();
            new Metrics(this, 508);
            if (this.getConfig().getBoolean("General.CheckForUpdates")) {
                UpdateSearcher searcher = new UpdateSearcher("Party-and-Friends-Free", this.getDescription().getVersion());
                ProxyServer.getInstance().getConsole().sendMessage((BaseComponent)new TextComponent(searcher.checkForUpdate()));
            }
        }
        catch (SQLException e) {
            if (e.getMessage().contains("Unable to load authentication plugin 'caching_sha2_password'.")) {
                this.initError(e, BootErrorType.SHA_ENCRYPTED_PASSWORD);
            }
            this.initError(e, BootErrorType.MYSQL_CONNECTION_PROBLEM);
        }
    }

    private void initError(Exception e, BootErrorType pType) {
        if (!this.getGeneralConfig().getBoolean("Commands.Party.TopCommands.Party.Disabled")) {
            this.registerCommand(new BootErrorCommand(this.getGeneralConfig().getStringList("Commands.Party.TopCommands.Party.Names").toArray(new String[0]), pType));
        }
        BootErrorCommand partyChatCommand = new BootErrorCommand(this.getGeneralConfig().getStringList("Commands.Party.TopCommands.PartyChat.Names").toArray(new String[0]), pType);
        if (!this.getGeneralConfig().getBoolean("Commands.Party.TopCommands.PartyChat.Disabled")) {
            this.registerCommand(partyChatCommand);
        }
        if (!this.getGeneralConfig().getBoolean("Commands.Friends.TopCommands.Friend.Disabled")) {
            this.registerCommand(new BootErrorCommand(this.getGeneralConfig().getStringList("Commands.Friends.TopCommands.Friend.Names").toArray(new String[0]), pType));
        }
        BootErrorCommand msg = new BootErrorCommand(this.getGeneralConfig().getStringList("Commands.Friends.TopCommands.MSG.Names").toArray(new String[0]), pType);
        if (!this.getGeneralConfig().getBoolean("Commands.Friends.TopCommands.MSG.Disabled")) {
            this.registerCommand(msg);
        }
        if (!this.getGeneralConfig().getBoolean("Commands.Friends.TopCommands.Reply.Disabled")) {
            this.registerCommand(new BootErrorCommand(this.getGeneralConfig().getStringList("Commands.Friends.TopCommands.Reply.Names").toArray(new String[0]), pType));
        }
        CommandSender console = ProxyServer.getInstance().getConsole();
        this.reportError(console, pType);
        e.printStackTrace();
    }

    private void initPAFClasses() throws SQLException {
        PoolData poolData = new PoolData(Main.getInstance().getGeneralConfig().getInt("MySQL.Pool.MinPoolSize"), Main.getInstance().getGeneralConfig().getInt("MySQL.Pool.MaxPoolSize"), Main.getInstance().getGeneralConfig().getInt("MySQL.Pool.InitialPoolSize"), Main.getInstance().getGeneralConfig().getInt("MySQL.Pool.IdleConnectionTestPeriod"), Main.getInstance().getGeneralConfig().getBoolean("MySQL.Pool.TestConnectionOnCheckin"));
        MySQLData mySQLData = new MySQLData(this.getGeneralConfig().get("MySQL.Host").toString(), this.getGeneralConfig().get("MySQL.Username").toString(), this.getGeneralConfig().get("MySQL.Password").toString(), this.getGeneralConfig().getInt("MySQL.Port"), this.getGeneralConfig().get("MySQL.Database").toString(), this.getGeneralConfig().get("MySQL.TablePrefix").toString(), this.getGeneralConfig().getBoolean("MySQL.UseSSL"), this.getGeneralConfig().getBoolean("MySQL.Cache"), false, 0);
        new PAFPlayerManagerMySQL(mySQLData, poolData);
        if (this.getGeneralConfig().getBoolean("General.MultiCoreEnhancement")) {
            PAFPlayerMySQL.setMultiCoreEnhancement(true);
            this.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("Multi Core Enhancement is activated."));
        }
        new LocalPartyManager(Main.getInstance().getGeneralConfig().getInt("Commands.Party.SubCommands.Invite.InvitationTimeOutTimeInSeconds"));
        new StandardPermissionProvider();
        new ServerDisplayNameCollection(this.getGeneralConfig());
    }

    public void onDisable() {
        ProxyServer.getInstance().getPluginManager().unregisterListeners((Plugin)this);
        ProxyServer.getInstance().getPluginManager().unregisterCommands((Plugin)this);
        Disabler.getInstance().disableAll();
        this.getProxy().getScheduler().cancel((Plugin)this);
    }

    private void loadConfiguration() {
        try {
            this.config = new ConfigLoader(new File(Main.getInstance().getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.language = Language.valueOf(this.getGeneralConfig().getString("General.Language").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.getProxy().getConsole().sendMessage((BaseComponent)new TextComponent("&4The given language is not supported by Party and Friends. English will be used instead."));
            this.language = Language.ENGLISH;
            e.printStackTrace();
        }
        try {
            this.messages = new MessagesLoader(this.language, this.getGeneralConfig().getBoolean("General.UseOwnLanguageFile"), new File(this.getDataFolder(), "messages.yml"), this);
            if (this.getGeneralConfig().getBoolean("General.UseOwnLanguageFile")) {
                this.language = Language.OWN;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.partyPrefix = this.getMessages().getString("Party.General.PartyPrefix");
        System.setProperty("de.simonsator.partyandfriends.c3p0.v2.log.MLog", "de.simonsator.partyandfriends.c3p0.v2.log.FallbackMLog");
        System.setProperty("de.simonsator.partyandfriends.c3p0.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL", "WARNING");
        this.getAdapter().setForceUuidSupport(this.config.getBoolean("General.ForceUUIDSupportOnOfflineServers"));
    }

    private void registerListeners() {
        BukkitBungeeAdapter.getInstance().registerListener(new PlayerDisconnectListener(), this);
        BukkitBungeeAdapter.getInstance().registerListener(new ServerSwitchListener(), this);
        JoinEvent joinEventListener = new JoinEvent();
        BukkitBungeeAdapter.getInstance().registerListener(joinEventListener, this);
        Exception e = joinEventListener.verify();
        if (e != null) {
            this.initError(e, BootErrorType.TOO_OLD_VERSION);
        }
    }

    private void registerCommands() {
        String friendsPrefix = this.getMessages().getString("Friends.General.Prefix");
        new PartyCommand(this.getGeneralConfig().getStringList("Commands.Party.TopCommands.Party.Names").toArray(new String[0]), this.partyPrefix);
        if (!this.getGeneralConfig().getBoolean("Commands.Party.TopCommands.Party.Disabled")) {
            this.registerTopCommand(PartyCommand.getInstance());
        }
        PartyChat partyChatCommand = new PartyChat(this.getGeneralConfig().getStringList("Commands.Party.TopCommands.PartyChat.Names").toArray(new String[0]), this.partyPrefix);
        if (!this.getGeneralConfig().getBoolean("Commands.Party.TopCommands.PartyChat.Disabled")) {
            this.registerTopCommand(partyChatCommand);
        }
        this.friendCommand = new Friends(this.getGeneralConfig().getStringList("Commands.Friends.TopCommands.Friend.Names"), friendsPrefix);
        if (!this.getGeneralConfig().getBoolean("Commands.Friends.TopCommands.Friend.Disabled")) {
            this.registerTopCommand(this.friendCommand);
        }
        MSG friendsMSGCommand = new MSG(this.getGeneralConfig().getStringList("Commands.Friends.TopCommands.MSG.Names").toArray(new String[0]), friendsPrefix);
        if (!this.getGeneralConfig().getBoolean("Commands.Friends.TopCommands.MSG.Disabled")) {
            this.registerTopCommand(friendsMSGCommand);
        }
        if (!this.getGeneralConfig().getBoolean("Commands.Friends.TopCommands.Reply.Disabled")) {
            this.registerTopCommand(new Reply(this.getGeneralConfig().getStringList("Commands.Friends.TopCommands.Reply.Names").toArray(new String[0]), friendsPrefix));
        }
        if (this.getGeneralConfig().getBoolean("Commands.PAFAdmin.Enabled")) {
            this.registerCommand((Object)new PAFAdminCommand(this.getGeneralConfig().getStringList("Commands.PAFAdmin.Names").toArray(new String[0])));
        }
    }

    @Deprecated
    public PartyChat getPartyChatCommand() {
        return PartyChat.getInstance();
    }

    @Deprecated
    public MSG getFriendsMSGCommand() {
        return MSG.getInstance();
    }

    @Deprecated
    public Friends getFriendsCommand() {
        return this.friendCommand;
    }

    @Deprecated
    public Configuration getConfig() {
        return this.config.getCreatedConfiguration();
    }

    @Deprecated
    public String getFriendsPrefix() {
        return Friends.getInstance().getPrefix();
    }

    public Language getLanguage() {
        return this.language;
    }

    public LanguageConfiguration getMessages() {
        return this.messages;
    }

    @Deprecated
    public LanguageConfiguration getMessagesYml() {
        return this.getMessages();
    }

    @Deprecated
    public PartyCommand getPartyCommand() {
        return PartyCommand.getInstance();
    }

    @Deprecated
    public String getPartyPrefix() {
        return PartyCommand.getInstance().getPrefix();
    }

    public void registerExtension(PAFExtension pPAFExtension) {
        this.pafExtensions.add(pPAFExtension);
    }

    public void unregisterExtension(PAFExtension pPAFExtension) {
        this.pafExtensions.remove((Object)pPAFExtension);
    }

    public void reload() {
        this.onDisable();
        this.onEnable();
        ArrayList<PAFExtension> toReload = new ArrayList<PAFExtension>(this.pafExtensions);
        this.pafExtensions.clear();
        for (PAFExtension extension : toReload) {
            extension.reload();
        }
    }
}

