/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.main.listener;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.OnlineStatusChangedMessageEvent;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.friends.commands.Friends;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.List;
import java.util.regex.Matcher;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class JoinEvent
implements Listener {
    private final boolean ONLINE_STATUS_CHANGE_SETTING_ENABLED;
    private final boolean FRIEND_REQUEST_NOTIFICATION;
    private final int PLAYER_SPLIT_LENGTH = Main.getInstance().getMessages().getString("Friends.Command.List.PlayerSplit").length();

    public JoinEvent() {
        this.FRIEND_REQUEST_NOTIFICATION = Main.getInstance().getGeneralConfig().getBoolean("General.SendFriendRequestNotificationOnJoin");
        this.ONLINE_STATUS_CHANGE_SETTING_ENABLED = Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.SubCommands.Settings.Settings.NotifyOnlineStatusChange.Enabled");
    }

    public Exception verify() {
        try {
            ProxiedPlayer.class.getMethod("isConnected", null);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return e;
        }
        return null;
    }

    @EventHandler(priority=32)
    public void onPostLogin(PostLoginEvent pEvent) {
        if (pEvent.getPlayer().isConnected()) {
            BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> this.sbLoggedIn(pEvent));
        }
    }

    private void sbLoggedIn(PostLoginEvent pEvent) {
        OnlinePAFPlayer player = PAFPlayerManager.getInstance().getPlayer(pEvent.getPlayer());
        if (!player.doesExist()) {
            player.createEntry();
            return;
        }
        player.update();
        List<PAFPlayer> friends = player.getFriends();
        List<PAFPlayer> friendRequests = player.getRequests();
        if (friends.isEmpty() && friendRequests.isEmpty()) {
            return;
        }
        boolean noFriends = friends.isEmpty();
        if (!friendRequests.isEmpty() && this.FRIEND_REQUEST_NOTIFICATION) {
            this.deliverFriendRequests(player, friendRequests);
        }
        if (player.getSettingsWorth(3) == 1) {
            noFriends = true;
        }
        if (!noFriends) {
            this.sendNowOnline(player, friends);
        }
    }

    private void deliverFriendRequests(OnlinePAFPlayer pPlayer, List<PAFPlayer> pFriendRequests) {
        StringBuilder content = new StringBuilder();
        for (PAFPlayer player : pFriendRequests) {
            content.append(Main.getInstance().getMessages().getString("Friends.General.RequestInfoOnJoinColor"));
            content.append(player.getDisplayName());
            content.append(Main.getInstance().getMessages().getString("Friends.General.RequestInfoOnJoinColorComma"));
            content.append(Main.getInstance().getMessages().getString("Friends.Command.List.PlayerSplit"));
        }
        pPlayer.sendMessage(PatterCollection.FRIEND_REQUEST_COUNT_PATTERN.matcher(PatterCollection.FRIEND_REQUEST_PATTERN.matcher(Friends.getInstance().getPrefix() + Main.getInstance().getMessages().getString("Friends.General.RequestInfoOnJoin")).replaceAll(Matcher.quoteReplacement(content.substring(0, content.length() - this.PLAYER_SPLIT_LENGTH)))).replaceAll(Matcher.quoteReplacement(pFriendRequests.size() + "")));
    }

    private void sendNowOnline(OnlinePAFPlayer pPlayer, List<PAFPlayer> pFriends) {
        String message = Friends.getInstance().getPrefix() + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Friends.General.PlayerIsNowOnline")).replaceAll(Matcher.quoteReplacement(pPlayer.getDisplayName()));
        OnlineStatusChangedMessageEvent event = new OnlineStatusChangedMessageEvent(pPlayer, message, pFriends);
        BukkitBungeeAdapter.getInstance().callEvent((Object)event);
        if (!event.isCancelled()) {
            for (PAFPlayer friend : event.getFriends()) {
                if (!this.ONLINE_STATUS_CHANGE_SETTING_ENABLED || friend.getSettingsWorth(101) != 0) continue;
                friend.sendMessage(event.getMessage());
            }
        }
    }
}

