/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.main.listener;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.OnlineStatusChangedMessageEvent;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.friends.commands.Friends;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.UUID;
import java.util.regex.Matcher;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class PlayerDisconnectListener
implements Listener {
    private final boolean ONLINE_STATUS_CHANGE_SETTING_ENABLED = Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.SubCommands.Settings.Settings.NotifyOnlineStatusChange.Enabled");

    @EventHandler
    public void onPlayerDisconnect(PlayerDisconnectEvent pEvent) {
        if (pEvent.getPlayer().getServer() == null) {
            return;
        }
        UUID uuid = pEvent.getPlayer().getUniqueId();
        BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> this.playerDisconnected(pEvent, uuid));
    }

    private void playerDisconnected(PlayerDisconnectEvent pEvent, UUID pUUID) {
        PAFPlayer player = PAFPlayerManager.getInstance().getPlayer(pUUID);
        PlayerParty party = PartyManager.getInstance().getParty(pUUID);
        if (party != null) {
            party.leaveParty(player);
        }
        if (player.getSettingsWorth(3) != 1) {
            String message = Friends.getInstance().getPrefix() + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Friends.General.PlayerIsNowOffline")).replaceAll(Matcher.quoteReplacement(player.getDisplayName()));
            OnlineStatusChangedMessageEvent event = new OnlineStatusChangedMessageEvent(player, message, player.getFriends());
            BukkitBungeeAdapter.getInstance().callEvent((Object)event);
            if (!event.isCancelled()) {
                for (PAFPlayer friend : event.getFriends()) {
                    if (!this.ONLINE_STATUS_CHANGE_SETTING_ENABLED || friend.getSettingsWorth(101) != 0) continue;
                    friend.sendMessage(event.getMessage());
                }
            }
            player.updateLastOnline();
        }
    }
}

