/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.main.listener;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.party.command.PartyCommand;
import de.simonsator.partyandfriends.utilities.ServerDisplayNameCollection;
import java.util.List;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.event.ServerSwitchEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

public class ServerSwitchListener
implements Listener {
    private static ServerSwitchListener instance;
    private final List<String> notJoinServers = Main.getInstance().getGeneralConfig().getStringList("General.PartyDoNotJoinTheseServers");
    private final int CONNECT_DELAY = Main.getInstance().getGeneralConfig().getInt("General.PartyJoinDelayInSeconds");

    public ServerSwitchListener() {
        instance = this;
    }

    public static ServerSwitchListener getInstance() {
        return instance;
    }

    @EventHandler
    public void onServerSwitch(ServerSwitchEvent pEvent) {
        BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> this.moveParty(pEvent));
    }

    private void moveParty(ServerSwitchEvent pEvent) {
        ServerInfo server = pEvent.getPlayer().getServer().getInfo();
        if (this.notJoinServers.contains(server.getName())) {
            return;
        }
        OnlinePAFPlayer player = PAFPlayerManager.getInstance().getPlayer(pEvent.getPlayer());
        PlayerParty party = PartyManager.getInstance().getParty(player);
        if (party != null && party.isLeader(player) && !party.getPlayers().isEmpty()) {
            for (OnlinePAFPlayer p : party.getPlayers()) {
                if (this.CONNECT_DELAY == 0) {
                    p.connect(server);
                    continue;
                }
                BukkitBungeeAdapter.getInstance().schedule(Main.getInstance(), () -> p.connect(server), this.CONNECT_DELAY);
            }
            party.sendMessage(PartyCommand.getInstance().getPrefix() + Main.getInstance().getMessages().getString("Party.Command.General.ServerSwitched").replace("[SERVER]", ServerDisplayNameCollection.getInstance().getServerDisplayName(server)));
        }
    }
}

