/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.pafplayers.mysql;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.PAFAccountCreateEvent;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.pafplayers.manager.PAFPlayerManagerMySQL;
import de.simonsator.partyandfriends.pafplayers.mysql.PAFPlayerMySQL;
import java.util.UUID;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.packet.Chat;

public class OnlinePAFPlayerMySQL
extends PAFPlayerMySQL
implements OnlinePAFPlayer {
    private final ProxiedPlayer PLAYER;

    public OnlinePAFPlayerMySQL(int pID, ProxiedPlayer pPlayer) {
        super(pID);
        this.PLAYER = pPlayer;
    }

    @Override
    public void createEntry() {
        this.id = PAFPlayerManagerMySQL.getConnection().firstJoin(this.PLAYER);
        BukkitBungeeAdapter.getInstance().callEvent((Object)new PAFAccountCreateEvent(this));
    }

    @Override
    public String getName() {
        return this.PLAYER.getName();
    }

    @Override
    public UUID getUniqueId() {
        return this.PLAYER.getUniqueId();
    }

    @Override
    public void connect(ServerInfo pInfo) {
        OnlinePAFPlayerMySQL.getServerConnector().connect(this.PLAYER, pInfo);
    }

    @Override
    public void sendMessage(TextComponent pTextComponent) {
        this.PLAYER.sendMessage((BaseComponent)pTextComponent);
    }

    @Override
    public boolean teleportTo(OnlinePAFPlayer pPlayer) {
        ServerInfo serverInfo = pPlayer.getServer();
        if (serverInfo != null && !this.getServer().equals(serverInfo)) {
            this.connect(pPlayer.getServer());
            return true;
        }
        return false;
    }

    @Override
    public ServerInfo getServer() {
        return this.PLAYER.getServer() != null ? this.PLAYER.getServer().getInfo() : null;
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public ProxiedPlayer getPlayer() {
        return this.PLAYER;
    }

    @Override
    public int changeSettingsWorth(int pSettingsID) {
        return PAFPlayerManagerMySQL.getConnection().changeSettingsWorth(this.id, pSettingsID);
    }

    @Override
    public void sendPacket(Chat chat) {
        this.PLAYER.unsafe().sendPacket((DefinedPacket)chat);
    }

    @Override
    public void sendPacket(TextComponent chat) {
        this.sendMessage(chat);
    }

    @Override
    public String getDisplayName() {
        return OnlinePAFPlayerMySQL.getDisplayNameProvider().getDisplayName(this);
    }

    @Override
    public void update() {
        if (BukkitBungeeAdapter.getInstance().isOnlineMode()) {
            PAFPlayerManagerMySQL.getConnection().updatePlayerName(this.getPlayerID(), this.PLAYER.getName());
        } else if (!this.PLAYER.getName().equals(PAFPlayerManagerMySQL.getConnection().getName(this.getPlayerID())) && !this.PLAYER.getUniqueId().equals(PAFPlayerManagerMySQL.getConnection().getUUID(this.getPlayerID()))) {
            PAFPlayerManagerMySQL.getConnection().updateUUID(this.getPlayerID(), this.PLAYER.getUniqueId());
        }
    }
}

