/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.pafplayers.mysql;

import de.simonsator.partyandfriends.api.PermissionProvider;
import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.PAFAccountDeleteEvent;
import de.simonsator.partyandfriends.api.events.friends.FriendRemovedEvent;
import de.simonsator.partyandfriends.api.events.friends.FriendRequestAcceptedEvent;
import de.simonsator.partyandfriends.api.pafplayers.IDBasedPAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerClass;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.pafplayers.manager.PAFPlayerManagerMySQL;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PAFPlayerMySQL
extends PAFPlayerClass
implements IDBasedPAFPlayer {
    private static boolean multiCoreEnhancement = false;
    protected int id;
    private String name;
    private UUID uuid;

    public PAFPlayerMySQL(int pID) {
        this.id = pID;
    }

    public static void setMultiCoreEnhancement(boolean pUseMultiCoreEnhancment) {
        multiCoreEnhancement = pUseMultiCoreEnhancment;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name;
        }
        this.name = PAFPlayerManagerMySQL.getConnection().getName(this.id);
        return this.name;
    }

    @Override
    public int getPlayerID() {
        return this.id;
    }

    @Override
    public List<PAFPlayer> getFriends() {
        return this.idListToPAFPlayerList(PAFPlayerManagerMySQL.getConnection().getFriends(this.id));
    }

    @Override
    public UUID getUniqueId() {
        if (this.uuid != null) {
            return this.uuid;
        }
        this.uuid = PAFPlayerManagerMySQL.getConnection().getUUID(this.id);
        return this.uuid;
    }

    @Override
    public String toString() {
        return "{Name:\"" + this.getName() + "\", DisplayName:\"" + this.getDisplayName() + "\"}";
    }

    @Override
    public boolean doesExist() {
        return this.id > 0;
    }

    @Override
    public int getSettingsWorth(int pSettingsID) {
        return PAFPlayerManagerMySQL.getConnection().getSettingsWorth(this.id, pSettingsID);
    }

    @Override
    public List<PAFPlayer> getRequests() {
        return this.idListToPAFPlayerList(PAFPlayerManagerMySQL.getConnection().getRequests(this.id));
    }

    @Override
    public int getFriendRequestCount() {
        return PAFPlayerManagerMySQL.getConnection().getFriendCount(this.id);
    }

    @Override
    public boolean hasRequestFrom(PAFPlayer pPlayer) {
        return PAFPlayerManagerMySQL.getConnection().hasRequestFrom(this.id, ((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID());
    }

    @Override
    public boolean hasPermission(String pPermission) {
        return pPermission == null || pPermission.isEmpty() || PermissionProvider.getInstance().hasPermission(this, pPermission);
    }

    @Override
    public void denyRequest(PAFPlayer pPlayer) {
        if (multiCoreEnhancement) {
            BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> this.denyRequestNoMultiCoreEnhancement(pPlayer));
        } else {
            this.denyRequestNoMultiCoreEnhancement(pPlayer);
        }
    }

    public void denyRequestNoMultiCoreEnhancement(PAFPlayer pPlayer) {
        PAFPlayerManagerMySQL.getConnection().denyRequest(this.id, ((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID());
    }

    @Override
    public boolean isAFriendOf(PAFPlayer pPlayer) {
        return PAFPlayerManagerMySQL.getConnection().isAFriendOf(this.id, ((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID());
    }

    private List<PAFPlayer> idListToPAFPlayerList(List<Integer> pList) {
        ArrayList<PAFPlayer> list = new ArrayList<PAFPlayer>();
        for (int playerID : pList) {
            list.add(((PAFPlayerManagerMySQL)PAFPlayerManager.getInstance()).getPlayer(playerID));
        }
        return list;
    }

    @Override
    public PAFPlayer getLastPlayerWroteTo() {
        return ((PAFPlayerManagerMySQL)PAFPlayerManager.getInstance()).getPlayer(PAFPlayerManagerMySQL.getConnection().getLastPlayerWroteTo(this.id));
    }

    @Override
    public void sendFriendRequest(PAFPlayer pPlayer) {
        if (multiCoreEnhancement) {
            BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> this.sendFriendRequestNoMultiCoreEnhancement(pPlayer));
        } else {
            this.sendFriendRequestNoMultiCoreEnhancement(pPlayer);
        }
    }

    public void sendFriendRequestNoMultiCoreEnhancement(PAFPlayer pSender) {
        PAFPlayerManagerMySQL.getConnection().sendFriendRequest(((PAFPlayerMySQL)pSender).getPlayerID(), this.id);
    }

    @Override
    public void addFriend(PAFPlayer pPlayer) {
        BukkitBungeeAdapter.getInstance().callEvent((Object)new FriendRequestAcceptedEvent(this, pPlayer));
        if (multiCoreEnhancement) {
            BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> this.addFriendNoMultiCoreEnhancement(pPlayer));
        } else {
            this.addFriendNoMultiCoreEnhancement(pPlayer);
        }
    }

    public void addFriendNoMultiCoreEnhancement(PAFPlayer pPlayer) {
        PAFPlayerManagerMySQL.getConnection().addFriend(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.id);
    }

    @Override
    public PAFPlayer getPAFPlayer() {
        return this;
    }

    @Override
    public void removeFriend(PAFPlayer pPlayer) {
        BukkitBungeeAdapter.getInstance().callEvent((Object)new FriendRemovedEvent(this, pPlayer));
        if (multiCoreEnhancement) {
            BukkitBungeeAdapter.getInstance().runAsync(Main.getInstance(), () -> this.removeFriendNoMultiCoreEnhancement(pPlayer));
        } else {
            this.removeFriendNoMultiCoreEnhancement(pPlayer);
        }
    }

    public void removeFriendNoMultiCoreEnhancement(PAFPlayer pPlayer) {
        PAFPlayerManagerMySQL.getConnection().deleteFriend(((PAFPlayerMySQL)pPlayer.getPAFPlayer()).getPlayerID(), this.id);
    }

    @Override
    public void setSetting(int pSettingsID, int pNewWorth) {
        PAFPlayerManagerMySQL.getConnection().setSetting(this.id, pSettingsID, pNewWorth);
    }

    @Override
    public void setLastPlayerWroteFrom(PAFPlayer pLastWroteTo) {
        PAFPlayerManagerMySQL.getConnection().setLastPlayerWroteTo(this.id, ((PAFPlayerMySQL)pLastWroteTo.getPAFPlayer()).getPlayerID());
    }

    @Override
    public long getLastOnline() {
        Timestamp time = PAFPlayerManagerMySQL.getConnection().getLastOnline(this.id);
        if (time != null) {
            return time.getTime();
        }
        return 0L;
    }

    @Override
    public boolean deleteAccount() {
        PAFAccountDeleteEvent event = new PAFAccountDeleteEvent(this);
        BukkitBungeeAdapter.getInstance().callEvent((Object)event);
        if (!event.isCancelled()) {
            PAFPlayerManagerMySQL.getConnection().deletePlayerEntry(this.id);
            return true;
        }
        return false;
    }

    @Override
    public void updateLastOnline() {
        PAFPlayerManagerMySQL.getConnection().updateLastOnline(this.getPlayerID());
    }
}

