/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.party.command;

import de.simonsator.partyandfriends.api.TopCommand;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.api.party.abstractcommands.PartySubCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.party.subcommand.Chat;
import de.simonsator.partyandfriends.party.subcommand.Info;
import de.simonsator.partyandfriends.party.subcommand.Invite;
import de.simonsator.partyandfriends.party.subcommand.Join;
import de.simonsator.partyandfriends.party.subcommand.Kick;
import de.simonsator.partyandfriends.party.subcommand.Leader;
import de.simonsator.partyandfriends.party.subcommand.Leave;
import de.simonsator.partyandfriends.party.subcommand.PartyDenySubCommand;
import de.simonsator.partyandfriends.party.subcommand.PartyInviteSettingSubCommand;
import de.simonsator.partyandfriends.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.utilities.LanguageConfiguration;
import java.util.Arrays;
import java.util.Vector;

public class PartyCommand
extends TopCommand<PartySubCommand> {
    private static PartyCommand instance;

    public PartyCommand(String[] pCommandNames, String pPrefix) {
        super(pCommandNames, Main.getInstance().getGeneralConfig().getString("Commands.Party.TopCommands.Party.Permissions"), pPrefix);
        instance = this;
        ConfigurationCreator config = Main.getInstance().getGeneralConfig();
        LanguageConfiguration messages = Main.getInstance().getMessages();
        this.subCommands.add(new Join(config.getStringList("Commands.Party.SubCommands.Join.Names"), config.getInt("Commands.Party.SubCommands.Join.Priority"), messages.getString("Party.CommandUsage.Join"), config.getString("Commands.Party.SubCommands.Join.Permissions")));
        this.subCommands.add(new Invite(config.getStringList("Commands.Party.SubCommands.Invite.Names"), config.getInt("Commands.Party.SubCommands.Invite.Priority"), messages.getString("Party.CommandUsage.Invite"), config.getString("Commands.Party.SubCommands.Invite.Permissions")));
        if (!config.getBoolean("Commands.Party.SubCommands.Deny.Disabled")) {
            this.subCommands.add(new PartyDenySubCommand(config.getStringList("Commands.Party.SubCommands.Deny.Names"), config.getInt("Commands.Party.SubCommands.Deny.Priority"), messages.getString("Party.CommandUsage.Deny"), config.getString("Commands.Party.SubCommands.Deny.Permissions")));
        }
        if (!config.getBoolean("Commands.Party.SubCommands.Kick.Disabled")) {
            this.subCommands.add(new Kick(config.getStringList("Commands.Party.SubCommands.Kick.Names"), config.getInt("Commands.Party.SubCommands.Kick.Priority"), messages.getString("Party.CommandUsage.Kick"), config.getString("Commands.Party.SubCommands.Kick.Permissions")));
        }
        if (!config.getBoolean("Commands.Party.SubCommands.Info.Disabled")) {
            this.subCommands.add(new Info(config.getStringList("Commands.Party.SubCommands.Info.Names"), config.getInt("Commands.Party.SubCommands.Kick.Priority"), messages.getString("Party.CommandUsage.List"), config.getString("Commands.Party.SubCommands.Info.Permissions")));
        }
        this.subCommands.add(new Leave(config.getStringList("Commands.Party.SubCommands.Leave.Names"), config.getInt("Commands.Party.SubCommands.Leave.Priority"), messages.getString("Party.CommandUsage.Leave"), config.getString("Commands.Party.SubCommands.Leave.Permissions")));
        if (!config.getBoolean("Commands.Party.SubCommands.Chat.Disabled")) {
            this.subCommands.add(new Chat(config.getStringList("Commands.Party.SubCommands.Chat.Names"), config.getInt("Commands.Party.SubCommands.Chat.Priority"), messages.getString("Party.CommandUsage.Chat"), config.getString("Commands.Party.SubCommands.Chat.Permissions")));
        }
        if (!config.getBoolean("Commands.Party.SubCommands.Leader.Disabled")) {
            this.subCommands.add(new Leader(config.getStringList("Commands.Party.SubCommands.Leader.Names"), config.getInt("Commands.Party.SubCommands.Leader.Priority"), messages.getString("Party.CommandUsage.Leader"), config.getString("Commands.Party.SubCommands.Leader.Permissions")));
        }
        if (!config.getBoolean("Commands.Party.SubCommands.InviteSetting.Disabled")) {
            this.subCommands.add(new PartyInviteSettingSubCommand(config.getStringList("Commands.Party.SubCommands.InviteSetting.Names"), config.getInt("Commands.Party.SubCommands.InviteSetting.Priority"), messages.getString("Party.CommandUsage.InviteSetting"), config.getString("Commands.Party.SubCommands.InviteSetting.Permissions")));
        }
    }

    public static PartyCommand getInstance() {
        return instance;
    }

    private PartySubCommand getCommand(String name) {
        for (PartySubCommand c : this.subCommands) {
            if (!c.isApplicable(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    protected void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        if (args.length == 0) {
            PlayerParty party = PartyManager.getInstance().getParty(pPlayer);
            pPlayer.sendMessage(Main.getInstance().getMessages().getString("Party.General.HelpBegin"));
            int permissionHeight = 0;
            if (party != null) {
                permissionHeight = party.isLeader(pPlayer) ? 2 : 1;
            }
            for (PartySubCommand cmd : this.subCommands) {
                if (!cmd.hasAccess(party, permissionHeight) && Main.getInstance().getGeneralConfig().getBoolean("Commands.Party.General.PrintOnlyExecutableSubCommandsOut")) continue;
                cmd.printOutHelp(pPlayer, this.getName());
            }
            pPlayer.sendMessage(Main.getInstance().getMessages().getString("Party.General.HelpEnd"));
            return;
        }
        PartySubCommand sc = this.getCommand(args[0]);
        if (sc == null) {
            pPlayer.sendMessage(Main.getInstance().getMessages().get(this.getPrefix(), "Party.Error.CommandNotFound"));
            return;
        }
        if (!sc.hasPermission(pPlayer)) {
            pPlayer.sendMessage(this.getPrefix() + Main.getInstance().getMessages().getString("Party.Error.NoPermission"));
            return;
        }
        Vector<String> a = new Vector<String>(Arrays.asList(args));
        a.remove(0);
        args = a.toArray(new String[a.size()]);
        sc.onCommand(pPlayer, args);
    }
}

