/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.party.playerpartys;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.party.PartyJoinEvent;
import de.simonsator.partyandfriends.api.events.party.PartyLeaderChangedEvent;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.party.command.PartyCommand;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;

public class LocalPlayerParty
extends PlayerParty {
    private final List<UUID> players = new ArrayList<UUID>();
    private final List<UUID> invited = new ArrayList<UUID>();
    private UUID leader;
    private boolean privateParty = true;
    private final Set<UUID> bannedPlayers = new HashSet<UUID>();

    public LocalPlayerParty(OnlinePAFPlayer leader) {
        this.leader = leader.getUniqueId();
    }

    @Override
    public boolean isLeader(PAFPlayer player) {
        return this.leader != null && player != null && this.leader.equals(player.getUniqueId());
    }

    @Override
    public boolean isBanned(PAFPlayer pPlayer) {
        return this.bannedPlayers.contains(pPlayer.getUniqueId());
    }

    @Override
    public void setBanned(PAFPlayer pPlayer, boolean pIsBanned) {
        if (pIsBanned) {
            this.bannedPlayers.add(pPlayer.getUniqueId());
        } else {
            this.bannedPlayers.remove(pPlayer.getUniqueId());
        }
    }

    @Override
    public boolean isPrivate() {
        return this.privateParty;
    }

    @Override
    public void setPrivateState(boolean pIsPrivate) {
        this.privateParty = pIsPrivate;
    }

    @Override
    protected boolean isAMember(OnlinePAFPlayer pPlayer) {
        return this.players.contains(pPlayer.getUniqueId());
    }

    @Override
    protected List<UUID> getInvited() {
        return this.invited;
    }

    @Override
    public OnlinePAFPlayer getLeader() {
        if (this.leader == null) {
            return null;
        }
        PAFPlayer pafPlayer = PAFPlayerManager.getInstance().getPlayer(this.leader);
        if (!(pafPlayer instanceof OnlinePAFPlayer)) {
            return null;
        }
        return (OnlinePAFPlayer)pafPlayer;
    }

    @Override
    public void setLeader(OnlinePAFPlayer player) {
        this.leader = player.getUniqueId();
        PartyManager.getInstance().addPlayerToParty(player, this);
        this.players.remove(player.getUniqueId());
        BukkitBungeeAdapter.getInstance().callEvent((Object)new PartyLeaderChangedEvent(this, player));
    }

    @Override
    public List<OnlinePAFPlayer> getPlayers() {
        ArrayList<OnlinePAFPlayer> lPlayers = new ArrayList<OnlinePAFPlayer>();
        for (UUID player : this.players) {
            PAFPlayer pafPlayer = PAFPlayerManager.getInstance().getPlayer(player);
            if (!(pafPlayer instanceof OnlinePAFPlayer)) continue;
            lPlayers.add((OnlinePAFPlayer)pafPlayer);
        }
        return lPlayers;
    }

    @Override
    public boolean addPlayer(OnlinePAFPlayer pPlayer) {
        if (!(this.players.contains(pPlayer.getUniqueId()) || !this.invited.contains(pPlayer.getUniqueId()) && !this.isLeader(pPlayer) && this.privateParty || this.isBanned(pPlayer))) {
            PartyJoinEvent partyJoinEvent = new PartyJoinEvent(this, pPlayer);
            BukkitBungeeAdapter.getInstance().callEvent((Object)partyJoinEvent);
            if (partyJoinEvent.isCancelled()) {
                return false;
            }
            this.players.add(pPlayer.getUniqueId());
            PartyManager.getInstance().addPlayerToParty(pPlayer, this);
            this.removeFromInvited(pPlayer);
            return true;
        }
        return false;
    }

    @Override
    public void removeFromInvited(PAFPlayer pPlayer) {
        this.invited.remove(pPlayer.getUniqueId());
    }

    @Override
    protected void addToInvited(OnlinePAFPlayer pPlayer) {
        this.invited.add(pPlayer.getUniqueId());
    }

    @Override
    protected void removePlayerSilent(PAFPlayer pPlayer) {
        this.players.remove(pPlayer.getUniqueId());
        PartyManager.getInstance().removePlayerFromParty(pPlayer);
    }

    @Override
    public int getInviteListSize() {
        return this.invited.size();
    }

    @Override
    protected boolean needsNewLeader(PAFPlayer pPlayer) {
        if (this.isLeader(pPlayer)) {
            this.leader = null;
            return true;
        }
        return false;
    }

    @Override
    protected void findNewLeader() {
        OnlinePAFPlayer newLeader = this.getPlayers().get(0);
        this.removePlayerSilent(newLeader);
        this.setLeader(newLeader);
        this.sendMessage(PartyCommand.getInstance().getPrefix() + PatterCollection.NEW_LEADER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Leave.NewLeaderIs")).replaceAll(Matcher.quoteReplacement(this.getLeader().getDisplayName())));
    }
}

