/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.party.subcommand;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.api.party.abstractcommands.PartySubCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.List;
import java.util.regex.Matcher;

public class Info
extends PartySubCommand {
    public Info(List<String> pCommands, int pPriority, String pHelpText, String pPermission) {
        super(pCommands, pPriority, pHelpText, pPermission);
    }

    @Override
    public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        String players;
        PlayerParty party = PartyManager.getInstance().getParty(pPlayer);
        if (!this.isInParty(pPlayer, party)) {
            return;
        }
        String leader = PatterCollection.LEADER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Info.Leader")).replaceAll(Matcher.quoteReplacement(party.getLeader().getDisplayName()));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(Main.getInstance().getMessages().getString("Party.Command.Info.Players"));
        List<OnlinePAFPlayer> partyPlayers = party.getPlayers();
        if (partyPlayers.isEmpty()) {
            stringBuilder.append(Main.getInstance().getMessages().getString("Party.Command.Info.Empty"));
            players = stringBuilder.toString();
        } else {
            for (OnlinePAFPlayer pp : partyPlayers) {
                stringBuilder.append(pp.getDisplayName());
                stringBuilder.append(Main.getInstance().getMessages().getString("Party.Command.Info.PlayersCut"));
            }
            players = stringBuilder.substring(0, stringBuilder.lastIndexOf(Main.getInstance().getMessages().getString("Party.Command.Info.PlayersCut")));
        }
        pPlayer.sendMessage(Main.getInstance().getMessages().getString("Party.General.HelpBegin"));
        pPlayer.sendMessage(this.PREFIX + leader);
        pPlayer.sendMessage(this.PREFIX + players);
        pPlayer.sendMessage(Main.getInstance().getMessages().getString("Party.General.HelpEnd"));
    }

    @Override
    public boolean hasAccess(int pPermissionHeight) {
        return 1 <= pPermissionHeight;
    }
}

