/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.party.subcommand;

import de.simonsator.partyandfriends.api.adapter.BukkitBungeeAdapter;
import de.simonsator.partyandfriends.api.events.command.party.InviteEvent;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.api.party.abstractcommands.PartyJoinInviteSubCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.List;
import java.util.regex.Matcher;

public class Invite
extends PartyJoinInviteSubCommand {
    public Invite(List<String> pCommands, int pPriority, String pHelpText, String pPermission) {
        super(pCommands, pPriority, pHelpText, pPermission, Main.getInstance().getMessages().getString("Party.Command.Invite.MaxPlayersInPartyReached"));
    }

    @Override
    public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        if (!this.isPlayerGiven(pPlayer, args)) {
            return;
        }
        PAFPlayer playerQuery = PAFPlayerManager.getInstance().getPlayer(args[0]);
        if (this.isPlayerOffline(pPlayer, playerQuery)) {
            return;
        }
        OnlinePAFPlayer toInvite = (OnlinePAFPlayer)playerQuery;
        if (this.senderEqualsSearched(pPlayer, toInvite)) {
            return;
        }
        boolean justCreated = false;
        PlayerParty party = PartyManager.getInstance().getParty(pPlayer);
        if (party == null) {
            party = PartyManager.getInstance().createParty(pPlayer);
            justCreated = true;
        }
        if (!this.isPartyLeader(pPlayer, party)) {
            return;
        }
        if (!this.allowsInvitation(pPlayer, toInvite)) {
            return;
        }
        if (this.isAlreadyInAParty(pPlayer, toInvite)) {
            if (justCreated) {
                PartyManager.getInstance().deleteParty(party);
            }
            return;
        }
        if (this.isAlreadyInvited(pPlayer, toInvite, party)) {
            return;
        }
        if (!this.canInvite(pPlayer, party, pPlayer)) {
            return;
        }
        InviteEvent event = new InviteEvent(pPlayer, toInvite, args, this);
        BukkitBungeeAdapter.getInstance().callEvent((Object)event);
        if (event.isCancelled()) {
            return;
        }
        party.invite(toInvite);
        pPlayer.sendMessage(this.PREFIX + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Invite.InvitedPlayer")).replaceAll(Matcher.quoteReplacement(toInvite.getDisplayName())));
    }

    private boolean senderEqualsSearched(OnlinePAFPlayer pPlayer, OnlinePAFPlayer pSearched) {
        if (pPlayer.equals(pSearched)) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Invite.GivenPlayerEqualsSender"));
            return true;
        }
        return false;
    }

    private boolean isPartyLeader(OnlinePAFPlayer pPlayer, PlayerParty pParty) {
        if (!pParty.isLeader(pPlayer)) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.General.ErrorNotPartyLeader"));
            return false;
        }
        return true;
    }

    private boolean isAlreadyInAParty(OnlinePAFPlayer pPlayer, OnlinePAFPlayer pToInvite) {
        if (PartyManager.getInstance().getParty(pToInvite) != null) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Invite.AlreadyInAParty"));
            return true;
        }
        return false;
    }

    private boolean isAlreadyInvited(OnlinePAFPlayer pPlayer, OnlinePAFPlayer pToInvite, PlayerParty pParty) {
        if (!pParty.isPrivate()) {
            return false;
        }
        if (pParty.isInvited(pToInvite)) {
            pPlayer.sendMessage(this.PREFIX + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Invite.AlreadyInYourParty")).replaceAll(Matcher.quoteReplacement(pToInvite.getDisplayName())));
            return true;
        }
        return false;
    }

    private boolean isPlayerOffline(OnlinePAFPlayer pPlayer, PAFPlayer pSearched) {
        if (!pSearched.isOnline()) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Invite.CanNotInviteThisPlayer"));
            return true;
        }
        return false;
    }

    private boolean allowsInvitation(OnlinePAFPlayer pPlayer, OnlinePAFPlayer pQueryPlayer) {
        if (Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.SubCommands.Settings.Settings.PartyInvite.Enabled") && pQueryPlayer.getSettingsWorth(1) == 1 && !pPlayer.isAFriendOf(pQueryPlayer)) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Invite.CanNotInviteThisPlayer"));
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAccess(int pPermissionHeight) {
        return 2 == pPermissionHeight || 0 == pPermissionHeight;
    }
}

