/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.party.subcommand;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.api.party.PartyManager;
import de.simonsator.partyandfriends.api.party.PlayerParty;
import de.simonsator.partyandfriends.api.party.abstractcommands.PartyJoinInviteSubCommand;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.PatterCollection;
import java.util.List;
import java.util.regex.Matcher;
import net.md_5.bungee.api.config.ServerInfo;

public class Join
extends PartyJoinInviteSubCommand {
    public Join(List<String> pCommands, int pPriority, String pHelpText, String pPermission) {
        super(pCommands, pPriority, pHelpText, pPermission, Main.getInstance().getMessages().getString("Party.Command.Join.MaxPlayersInPartyReached"));
    }

    @Override
    public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
        if (!this.isPlayerGiven(pPlayer, args)) {
            return;
        }
        if (this.isInParty(pPlayer)) {
            return;
        }
        PAFPlayer pl = PAFPlayerManager.getInstance().getPlayer(args[0]);
        if (!pl.isOnline()) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Join.PlayerHasNoParty"));
            return;
        }
        OnlinePAFPlayer onlinePAFPlayer = (OnlinePAFPlayer)pl;
        PlayerParty party = PartyManager.getInstance().getParty(onlinePAFPlayer);
        if (this.hasNoParty(pPlayer, party)) {
            return;
        }
        if (!party.isPrivate() && !this.canInvite(party.getLeader(), party, pPlayer)) {
            return;
        }
        if (party.addPlayer(pPlayer)) {
            ServerInfo leaderServer;
            party.sendMessage(this.PREFIX + PatterCollection.PLAYER_PATTERN.matcher(Main.getInstance().getMessages().getString("Party.Command.Join.PlayerHasJoined")).replaceAll(Matcher.quoteReplacement(pPlayer.getDisplayName())));
            if (Main.getInstance().getGeneralConfig().getBoolean("Commands.Party.SubCommands.Join.AutoJoinLeaderServer") && !(leaderServer = party.getLeader().getServer()).equals(pPlayer.getServer())) {
                pPlayer.connect(leaderServer);
            }
        } else {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Join.ErrorNoInvitation"));
        }
    }

    @Override
    public boolean hasAccess(int pPermissionHeight) {
        return 0 == pPermissionHeight;
    }

    private boolean hasNoParty(OnlinePAFPlayer pPlayer, PlayerParty pParty) {
        if (pParty == null) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Join.PlayerHasNoParty"));
            return true;
        }
        return false;
    }

    private boolean isInParty(OnlinePAFPlayer pPlayer) {
        if (PartyManager.getInstance().getParty(pPlayer) != null) {
            pPlayer.sendMessage(this.PREFIX + Main.getInstance().getMessages().getString("Party.Command.Join.AlreadyInAPartyError"));
            return true;
        }
        return false;
    }
}

