/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.utilities;

import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.ConfigurationCreator;
import java.io.File;
import java.io.IOException;
import java.util.TimeZone;

public class ConfigLoader
extends ConfigurationCreator {
    public ConfigLoader(File file) throws IOException {
        super(file, Main.getInstance());
        this.readFile();
        this.loadDefaultValues();
        this.saveFile();
    }

    private void loadDefaultValues() {
        this.set("MySQL.Host", (Object)"localhost");
        this.set("MySQL.Port", 3306);
        this.set("MySQL.UseSSL", false);
        this.set("MySQL.Username", (Object)"root");
        this.set("MySQL.Password", (Object)"Password");
        this.set("MySQL.Database", (Object)"friends");
        this.set("MySQL.TablePrefix", (Object)"fr_");
        this.set("MySQL.Cache", true);
        this.set("MySQL.Pool.InitialPoolSize", 3);
        this.set("MySQL.Pool.MinPoolSize", 3);
        this.set("MySQL.Pool.MaxPoolSize", 15);
        this.set("MySQL.Pool.IdleConnectionTestPeriod", 290);
        this.set("MySQL.Pool.TestConnectionOnCheckin", false);
        this.set("General.UseOwnLanguageFile", false);
        this.set("General.CheckForUpdates", true);
        this.set("General.Language", (Object)"English");
        this.set("General.MultiCoreEnhancement", true);
        this.set("General.Time.LanguageTag", (Object)"US");
        this.set("General.Time.TimeZone", (Object)TimeZone.getDefault().getID());
        this.set("General.Time.Format", (Object)"dd/MM/yyyy HH:mm:ss");
        this.set("General.PartyDoNotJoinTheseServers", "lobby", "lobby1", "lobby2");
        this.set("General.PartyJoinDelayInSeconds", 0);
        this.set("General.DisabledServers", "login1", "login2");
        this.set("General.SendFriendRequestNotificationOnJoin", true);
        this.set("General.ForceUUIDSupportOnOfflineServers", false);
        this.set("ServerDisplayNames.Use", false);
        if (this.getBoolean("ServerDisplayNames.Use") && this.get("ServerDisplayNames.Replace") == null) {
            this.set("ServerDisplayNames.Replace.ExampleServer1.RealName", (Object)"lobby-server-21");
            this.set("ServerDisplayNames.Replace.ExampleServer1.ReplacedName", (Object)"Premium Lobby");
            this.set("ServerDisplayNames.Replace.ExampleServer2.RealName", (Object)"lobby-server-22");
            this.set("ServerDisplayNames.Replace.ExampleServer2.ReplacedName", (Object)"Admin Lobby");
        }
        this.set("Party.MaxPlayersPerParty.Default", 0);
        this.set("Party.MaxPlayersPerParty.NoLimitPermission", (Object)"");
        if (this.get("Party.MaxPlayersPerParty.AddSlotsPermissions") == null) {
            this.set("Party.MaxPlayersPerParty.AddSlotsPermissions.Premium.Permission", (Object)"de.simonsator.partyandfriends.party.addslots.premium");
            this.set("Party.MaxPlayersPerParty.AddSlotsPermissions.Premium.SlotsToAdd", 5);
            this.set("Party.MaxPlayersPerParty.AddSlotsPermissions.SuperPremium.Permission", (Object)"de.simonsator.partyandfriends.party.addslots.premium");
            this.set("Party.MaxPlayersPerParty.AddSlotsPermissions.SuperPremium.SlotsToAdd", 10);
        }
        this.set("Extensions.UseExtensionFolderAsConfigFolder", false);
        this.set("Commands.Friends.General.PrintOutHelpOnError", true);
        this.set("Commands.Friends.TopCommands.Friend.Names", "friend", "friends");
        this.set("Commands.Friends.TopCommands.Friend.Permissions", (Object)"");
        this.set("Commands.Friends.TopCommands.Friend.Disabled", false);
        this.set("Commands.Friends.TopCommands.Reply.Names", "reply", "r");
        this.set("Commands.Friends.TopCommands.Reply.Disabled", false);
        this.set("Commands.Friends.TopCommands.Reply.Permission", (Object)"");
        this.set("Commands.Friends.TopCommands.MSG.Names", "msg", "fmsg");
        this.set("Commands.Friends.TopCommands.MSG.Disabled", false);
        this.set("Commands.Friends.TopCommands.MSG.Permission", (Object)"");
        this.set("Commands.Friends.TopCommands.MSG.MSGNonFriendsPermission", (Object)"de.simonsator.partyandfriends.msg.msgnonfriends");
        this.set("Commands.Friends.TopCommands.MSG.AllowPlayersToUseChatFormatting", true);
        this.set("Commands.Friends.SubCommands.Accept.Names", "accept", "approve");
        this.set("Commands.Friends.SubCommands.Accept.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Accept.Priority", 3);
        this.set("Commands.Friends.SubCommands.Accept.SendTextIsNowOnline", true);
        this.set("Commands.Friends.SubCommands.Add.Names", "add", "addfriend");
        this.set("Commands.Friends.SubCommands.Add.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Add.Priority", 2);
        this.set("Commands.Friends.SubCommands.Add.FriendRequestTimeout", 0);
        this.set("Commands.Friends.SubCommands.Deny.Names", "deny", "reject");
        this.set("Commands.Friends.SubCommands.Deny.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Deny.Priority", 4);
        this.set("Commands.Friends.SubCommands.Jump.Names", "jump", "jumpto");
        this.set("Commands.Friends.SubCommands.Jump.Disabled", false);
        this.set("Commands.Friends.SubCommands.Jump.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Jump.Priority", 6);
        this.set("Commands.Friends.SubCommands.Jump.DisabledServers", "login1", "adminlobby1");
        this.set("Commands.Friends.SubCommands.List.Names", "list", "info");
        this.set("Commands.Friends.SubCommands.List.Disabled", false);
        this.set("Commands.Friends.SubCommands.List.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.List.Priority", 0);
        this.set("Commands.Friends.SubCommands.List.SortElements", true);
        this.set("Commands.Friends.SubCommands.List.EntriesPerPage", 10);
        this.set("Commands.Friends.SubCommands.MSG.Names", "msg", "message");
        this.set("Commands.Friends.SubCommands.MSG.Disabled", false);
        this.set("Commands.Friends.SubCommands.MSG.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.MSG.Priority", 1);
        this.set("Commands.Friends.SubCommands.MSG.ReplyCommand", (Object)"/friend msg [PLAYER]");
        this.set("Commands.Friends.SubCommands.Remove.Names", "remove", "deleteAccount");
        this.set("Commands.Friends.SubCommands.Remove.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Remove.Priority", 5);
        this.set("Commands.Friends.SubCommands.Remove.UseFriendRemovedYouMessage", false);
        this.set("Commands.Friends.SubCommands.Settings.Names", "setting", "settings");
        this.set("Commands.Friends.SubCommands.Settings.Disabled", false);
        this.set("Commands.Friends.SubCommands.Settings.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Settings.Priority", 7);
        this.set("Commands.Friends.SubCommands.Settings.Settings.FriendRequest.Names", "friendrequest", "receivefriendrequests", "friendrequests");
        this.set("Commands.Friends.SubCommands.Settings.Settings.FriendRequest.Enabled", true);
        this.set("Commands.Friends.SubCommands.Settings.Settings.FriendRequest.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Settings.Settings.FriendRequest.Priority", 0);
        this.set("Commands.Friends.SubCommands.Settings.Settings.Jump.Names", "jump", "allowjump");
        this.set("Commands.Friends.SubCommands.Settings.Settings.Jump.Enabled", true);
        this.set("Commands.Friends.SubCommands.Settings.Settings.Jump.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Settings.Settings.Jump.Priority", 1);
        this.set("Commands.Friends.SubCommands.Settings.Settings.Offline.Names", "offline", "alwaysoffline");
        this.set("Commands.Friends.SubCommands.Settings.Settings.Offline.Enabled", true);
        this.set("Commands.Friends.SubCommands.Settings.Settings.Offline.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Settings.Settings.Offline.Priority", 2);
        this.set("Commands.Friends.SubCommands.Settings.Settings.NotifyOnlineStatusChange.Names", "notifyonline", "notify");
        this.set("Commands.Friends.SubCommands.Settings.Settings.NotifyOnlineStatusChange.Enabled", true);
        this.set("Commands.Friends.SubCommands.Settings.Settings.NotifyOnlineStatusChange.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Settings.Settings.NotifyOnlineStatusChange.Priority", 3);
        this.set("Commands.Friends.SubCommands.Settings.Settings.PM.Names", "pm", "message", "messages");
        this.set("Commands.Friends.SubCommands.Settings.Settings.PM.Enabled", true);
        this.set("Commands.Friends.SubCommands.Settings.Settings.PM.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Settings.Settings.PM.Priority", 4);
        this.set("Commands.Friends.SubCommands.Settings.Settings.PartyInvite.Names", "invite", "party");
        this.set("Commands.Friends.SubCommands.Settings.Settings.PartyInvite.Enabled", true);
        this.set("Commands.Friends.SubCommands.Settings.Settings.PartyInvite.Permission", (Object)"");
        this.set("Commands.Friends.SubCommands.Settings.Settings.PartyInvite.Priority", 5);
        this.set("Commands.Party.General.PrintOutHelpOnError", true);
        this.set("Commands.Party.General.PrintOnlyExecutableSubCommandsOut", true);
        this.set("Commands.Party.TopCommands.Party.Names", "party", "parties");
        this.set("Commands.Party.TopCommands.Party.Permissions", (Object)"");
        this.set("Commands.Party.TopCommands.Party.Disabled", false);
        this.set("Commands.Party.TopCommands.PartyChat.Names", "partychat", "p");
        this.set("Commands.Party.TopCommands.PartyChat.Permissions", (Object)"");
        this.set("Commands.Party.TopCommands.PartyChat.Disabled", false);
        this.set("Commands.Party.SubCommands.Join.Names", "join", "j");
        this.set("Commands.Party.SubCommands.Join.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Join.Priority", 0);
        this.set("Commands.Party.SubCommands.Join.AutoJoinLeaderServer", true);
        this.set("Commands.Party.SubCommands.Deny.Names", "deny", "decline");
        this.set("Commands.Party.SubCommands.Deny.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Deny.Priority", 0);
        this.set("Commands.Party.SubCommands.Deny.Disabled", true);
        this.set("Commands.Party.SubCommands.Invite.Names", "invite", "add");
        this.set("Commands.Party.SubCommands.Invite.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Invite.Priority", 1);
        this.set("Commands.Party.SubCommands.Invite.InvitationTimeOutTimeInSeconds", 60);
        this.set("Commands.Party.SubCommands.InviteSetting.Names", "settings", "setting", "invitesetting");
        this.set("Commands.Party.SubCommands.InviteSetting.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.InviteSetting.Priority", 2);
        this.set("Commands.Party.SubCommands.InviteSetting.Disabled", true);
        this.set("Commands.Party.SubCommands.Kick.Names", "kick", "forcedleave");
        this.set("Commands.Party.SubCommands.Kick.Disabled", false);
        this.set("Commands.Party.SubCommands.Kick.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Kick.Priority", 6);
        this.set("Commands.Party.SubCommands.Info.Names", "info", "list");
        this.set("Commands.Party.SubCommands.Info.Disabled", false);
        this.set("Commands.Party.SubCommands.Info.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Info.Priority", 3);
        this.set("Commands.Party.SubCommands.Leave.Names", "leave", "le");
        this.set("Commands.Party.SubCommands.Leave.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Leave.Priority", 5);
        this.set("Commands.Party.SubCommands.Chat.Names", "chat", "message", "msg");
        this.set("Commands.Party.SubCommands.Chat.ReplyCommand", (Object)"chat");
        this.set("Commands.Party.SubCommands.Chat.Disabled", false);
        this.set("Commands.Party.SubCommands.Chat.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Chat.Priority", 4);
        this.set("Commands.Party.SubCommands.Leader.Names", "leader", "lead");
        this.set("Commands.Party.SubCommands.Leader.Disabled", false);
        this.set("Commands.Party.SubCommands.Leader.Permissions", (Object)"");
        this.set("Commands.Party.SubCommands.Leader.Priority", 7);
        this.set("Commands.PAFAdmin.Enabled", false);
        this.set("Commands.PAFAdmin.Names", "pafadmin", "adminpaf");
    }

    @Override
    public void reloadConfiguration() throws IOException {
        this.configuration = new ConfigLoader(this.FILE).getCreatedConfiguration();
    }
}

