/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.utilities;

import com.google.common.base.Charsets;
import de.simonsator.partyandfriends.api.PAFExtension;
import de.simonsator.partyandfriends.api.PAFPluginBase;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public abstract class ConfigurationCreator {
    protected final File FILE;
    private final Plugin PLUGIN;
    protected Configuration configuration = new Configuration();

    @Deprecated
    protected ConfigurationCreator(File file) {
        this.FILE = file;
        this.PLUGIN = null;
    }

    protected ConfigurationCreator(File file, PAFPluginBase pPlugin) {
        this(file, (Plugin)pPlugin);
    }

    @Deprecated
    protected ConfigurationCreator(File file, Plugin pPlugin) {
        this.FILE = file;
        this.PLUGIN = pPlugin;
    }

    protected ConfigurationCreator(File file, PAFExtension pPlugin) {
        this(file, (Plugin)pPlugin);
    }

    private void createParentFolder() {
        File parent = this.FILE.getParentFile();
        if (!parent.exists()) {
            parent.mkdir();
        }
    }

    protected void process() {
        this.process(this.getCreatedConfiguration());
    }

    protected void readFile() throws IOException {
        File folder = this.FILE.getParentFile();
        if (!folder.exists()) {
            folder.mkdir();
        }
        if (!this.FILE.exists()) {
            this.FILE.createNewFile();
        }
        try (InputStreamReader inputStream = new InputStreamReader((InputStream)new FileInputStream(this.FILE), Charsets.UTF_8);){
            this.configuration = ConfigurationProvider.getProvider(YamlConfiguration.class).load((Reader)inputStream);
        }
    }

    @Deprecated
    public void reloadConfiguration() throws IOException {
        throw new UnsupportedOperationException("This method was not implemented");
    }

    public Configuration getCreatedConfiguration() {
        return this.configuration;
    }

    protected void set(String pKey, Object pText) {
        if (this.configuration.get(pKey) == null) {
            this.configuration.set(pKey, pText);
        }
    }

    protected void set(String pKey, String ... entries) {
        this.set(pKey, new ArrayList<String>(Arrays.asList(entries)));
    }

    protected void saveFile() throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.FILE), Charsets.UTF_8);){
            ConfigurationProvider.getProvider(YamlConfiguration.class).save(this.configuration, (Writer)writer);
        }
    }

    protected void process(Configuration pMessagesYML) {
        for (String key : pMessagesYML.getKeys()) {
            Object entry = pMessagesYML.get(key);
            if (entry instanceof LinkedHashMap | entry instanceof Configuration) {
                this.process(pMessagesYML.getSection(key));
                continue;
            }
            if (entry instanceof String) {
                pMessagesYML.set(key, (Object)this.process((String)entry));
                continue;
            }
            if (!(entry instanceof List)) continue;
            ArrayList<String> messages = new ArrayList<String>((List)entry);
            for (int i = 0; i < messages.size(); ++i) {
                messages.set(i, this.process((String)messages.get(i)));
            }
            pMessagesYML.set(key, messages);
        }
    }

    private String process(String pMessage) {
        pMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)pMessage);
        return this.fixColors(pMessage);
    }

    private String fixColors(String pInput) {
        String[] split = pInput.split(" ");
        StringBuilder composite = new StringBuilder();
        String colorCode = "";
        String formatCode = "";
        Pattern formatPattern = Pattern.compile("(?i)\u00a7[K-OR]");
        for (String input : split) {
            int index;
            if (!input.startsWith("\u00a7")) {
                input = colorCode + formatCode + input;
            }
            String inputClone = input;
            while ((index = inputClone.indexOf(167)) != -1) {
                if (inputClone.length() > index) {
                    char colorFormatCharacter = inputClone.charAt(index + 1);
                    if (colorFormatCharacter == 'r') {
                        colorCode = "";
                        formatCode = "";
                    } else {
                        String temp = "\u00a7" + colorFormatCharacter;
                        if (formatPattern.matcher(temp).matches()) {
                            formatCode = temp;
                        } else {
                            colorCode = temp;
                        }
                    }
                }
                inputClone = inputClone.substring(index + 1);
            }
            composite.append(' ').append(input);
        }
        String composited = composite.toString();
        if (composited.length() > 0) {
            composited = composited.substring(1);
        }
        if (pInput.endsWith(" ")) {
            composited = composited + ' ';
        }
        return composited;
    }

    protected boolean copyFromJar() throws IOException {
        int len;
        if (this.PLUGIN == null) {
            throw new UnsupportedOperationException("Deprecated constructor was used to initialise the Object.");
        }
        if (this.FILE.exists()) {
            return false;
        }
        this.createParentFolder();
        InputStream in = this.PLUGIN.getResourceAsStream(this.FILE.getName());
        FileOutputStream out = new FileOutputStream(this.FILE);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        in.close();
        return true;
    }

    public String getString(String pIdentifier) {
        return this.configuration.getString(pIdentifier);
    }

    public int getInt(String pIdentifier) {
        return this.configuration.getInt(pIdentifier);
    }

    public long getLong(String pIdentifier) {
        return this.configuration.getLong(pIdentifier);
    }

    public boolean getBoolean(String pIdentifier) {
        return this.configuration.getBoolean(pIdentifier);
    }

    public List<String> getStringList(String pIdentifier) {
        return this.configuration.getStringList(pIdentifier);
    }

    public Object get(String pIdentifier) {
        return this.configuration.get(pIdentifier);
    }

    public Collection<String> getSectionKeys(String pIdentifier) {
        return this.getCreatedConfiguration().getSection(pIdentifier).getKeys();
    }
}

