/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.utilities;

import de.simonsator.partyandfriends.api.PAFPluginBase;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.Language;
import de.simonsator.partyandfriends.utilities.LanguageConfiguration;
import java.io.File;
import java.io.IOException;
import java.util.Collections;

public class MessagesLoader
extends LanguageConfiguration {
    private final boolean USE_CUSTOM_MESSAGES;

    public MessagesLoader(Language pLanguage, boolean useCustomMessages, File pFile, PAFPluginBase pPlugin) throws IOException {
        super(pLanguage, pFile, pPlugin);
        this.USE_CUSTOM_MESSAGES = useCustomMessages;
        this.copyFromJar();
        this.readFile();
        switch (pLanguage) {
            case GERMAN: {
                this.loadGermanMessages();
                break;
            }
        }
        this.loadEnglishMessages();
        this.loadSharedMessages();
        if (this.USE_CUSTOM_MESSAGES) {
            this.saveFile();
        }
        this.process();
    }

    private void loadEnglishMessages() {
        this.set("General.DisabledServer", (Object)"&cThis command cannot be executed here.");
        this.set("General.UnableToConnectToServerRedisBungee", (Object)"&cThe server could not be joined.");
        this.set("Party.Error.CommandNotFound", "&cThis command does not exist!", "&cThis command does not exist!");
        this.set("Party.Error.NoPermission", (Object)"&cYou don't have the permission to execute this command!");
        this.set("Party.CommandUsage.Join", (Object)"&8/&5Party join  &8- &7Join a party");
        this.set("Party.CommandUsage.Deny", (Object)"&8/&5Party deny  &8- &7Deny a party invitation");
        this.set("Party.CommandUsage.Invite", (Object)"&8/&5Party invite  &8- &7Invite a player into your party");
        this.set("Party.CommandUsage.InviteSetting", (Object)"&8/&5Party setting  &8- &7Enables/disables party invites");
        this.set("Party.CommandUsage.List", (Object)"&8/&5Party list &8- &7List all players who are in the party");
        this.set("Party.CommandUsage.Chat", (Object)"&8/&5Party chat  &8- &7Send all players in the party a message");
        this.set("Party.CommandUsage.Leave", (Object)"&8/&5Party leave &8- &7Leave the party");
        this.set("Party.CommandUsage.Kick", (Object)"&8/&5Party kick  &8- &7Kicks a player out of the party");
        this.set("Party.CommandUsage.Leader", (Object)"&8/&5Party leader &5 &8- &7Makes another player to the party leader");
        this.set("Party.Command.General.ErrorNoParty", (Object)"&5You need to be in a party.");
        this.set("Party.Command.General.ErrorNotPartyLeader", (Object)"&cYou are not the party leader.");
        this.set("Party.Command.General.ErrorGivenPlayerIsNotInTheParty", (Object)"&cThe player &e[PLAYER] &cis not in the party.");
        this.set("Party.Command.General.ErrorNoPlayer", (Object)"&cYou need to specify a player.");
        this.set("Party.Command.General.ErrorPlayerNotOnline", (Object)"&cThis player is not online.");
        this.set("Party.Command.General.DissolvedPartyCauseOfNotEnoughPlayers", (Object)"&5The party was dissolved because there are not enough players.");
        this.set("Party.Command.General.PlayerHasLeftTheParty", (Object)"&bThe player &6[PLAYER] &bhas left the party.");
        this.set("Party.Command.General.ServerSwitched", (Object)"&bThe party has joined the Server &e[SERVER]&b.");
        this.set("Party.Command.Chat.ErrorNoMessage", (Object)"&5You need to give in a message.");
        this.set("Party.Command.Info.Empty", (Object)"empty");
        this.set("Party.Command.Invite.GivenPlayerEqualsSender", (Object)"&7You are not allowed to invite yourself.");
        this.set("Party.Command.Invite.CanNotInviteThisPlayer", (Object)"&cYou cannot invite this player into your Party.");
        this.set("Party.Command.Invite.AlreadyInAParty", (Object)"&cThis player is already in a party.");
        this.set("Party.Command.Invite.AlreadyInYourParty", (Object)"&cThe player &e[PLAYER] &cis already invited into your party.");
        this.set("Party.Command.Invite.MaxPlayersInPartyReached", (Object)"&cThe max size of a party is [MAXPLAYERSINPARTY].");
        this.set("Party.Command.Invite.InvitedPlayer", (Object)"&6[PLAYER] &bwas invited to your party.");
        this.set("Party.Command.Invite.YouWereInvitedBY", (Object)"&5You were invited into &6[PLAYER]'s &5party!");
        this.set("Party.Command.Invite.AcceptInvite", (Object)"&aJoin the party by using the command &6/Party &6join &6[PLAYER]&a!");
        this.set("Party.Command.Invite.AcceptInviteHOVER", (Object)"&aClick here to join the party");
        this.set("Party.Command.Invite.DeclineInvite", (Object)"&cDecline the invitation by using the command &6/Party &6deny &6[PLAYER]&c!");
        this.set("Party.Command.Invite.DeclineInviteHOVER", (Object)"&cClick here to decline the invitation");
        this.set("Party.Command.Invite.InvitationTimedOutInvited", (Object)"&5The invitation of &6[PLAYER]'s &5party is timed out!");
        this.set("Party.Command.Invite.InvitationTimedOutLeader", (Object)"&5The player &6[PLAYER] &5has not accepted your invitation!");
        this.set("Party.Command.Join.PlayerHasNoParty", (Object)"&cThis player does not own a party.");
        this.set("Party.Command.Join.AlreadyInAPartyError", (Object)"&cYou are already in a party. Use &6/party leave &cto leave this party.");
        this.set("Party.Command.Join.PlayerHasJoined", (Object)"&bThe player &6[PLAYER] &bjoined the party.");
        this.set("Party.Command.Join.ErrorNoInvitation", (Object)"&cYou cannot join this party.");
        this.set("Party.Command.Join.MaxPlayersInPartyReached", (Object)"&cThe max size of a party is [MAXPLAYERSINPARTY].");
        this.set("Party.Command.Deny.PlayerHasNoParty", (Object)"&cThis player does not own a party.");
        this.set("Party.Command.Deny.PlayerHasDeniedInvitation", (Object)"&bThe player &6[PLAYER] &bhas declined the invitation.");
        this.set("Party.Command.Deny.DeniedInvitation", (Object)"&bYou denied the party invitation.");
        this.set("Party.Command.Deny.ErrorNoInvitation", (Object)"&cYou are not invited into that party.");
        this.set("Party.Command.Kick.KickedPlayerOutOfThePartyOthers", (Object)"&bThe player &6[PLAYER] &bwas kicked out of the party.");
        this.set("Party.Command.Kick.KickedPlayerOutOfThePartyKickedPlayer", (Object)"&bYou have been kicked out of the party.");
        this.set("Party.Command.Leader.SenderEqualsGivenPlayer", (Object)"&7You cannot make yourself the party leader.");
        this.set("Party.Command.Leader.NewLeaderIs", (Object)"&7The new party leader is &6[NEWLEADER]");
        this.set("Party.Command.Leave.NewLeaderIs", (Object)"&bThe leader has left the party. The new leader is &e[NEWLEADER].");
        this.set("Party.Command.Leave.YouLeftTheParty", Collections.singletonList("&bYou left your party."));
        this.set("Friends.General.CommandNotFound", " &cThe command does not exist.", " &cI am sorry, but the command you were searching for was not found.");
        this.set("Friends.General.NoPermission", (Object)" &cYou don't have the permission to execute this command.");
        this.set("Friends.General.PlayerIsOffline", (Object)" &7The player &e[PLAYER] &7is not online or you are not his friend.");
        this.set("Friends.General.NotAFriendOfOrOffline", (Object)" &7The player &e[PLAYER] &7is not online or you are not his friend.");
        this.set("Friends.General.NoFriendGiven", (Object)" &7You need to specify a friend.");
        this.set("Friends.General.NoPlayerGiven", (Object)" &7You need to specify a player.");
        this.set("Friends.General.PlayerIsNowOffline", (Object)" &7Your friend &e[PLAYER] &7is &coffline &7now.");
        this.set("Friends.General.PlayerIsNowOnline", (Object)" &7Your friend &e[PLAYER] &7is &aonline &7now.");
        this.set("Friends.General.RequestInfoOnJoin", (Object)" &7You &7have &7friend &7requests &7from: [FRIENDREQUESTS]");
        this.set("Friends.General.DoesNotExist", (Object)" &7The given player &7does not &7exist");
        this.set("Friends.General.GivenPlayerEqualsSender", (Object)" &7You cannot specify yourself as player argument.");
        this.set("Friends.CommandUsage.List", (Object)"&8/&5friend list &8- &7Lists all your friends");
        this.set("Friends.CommandUsage.MSG", (Object)"&8/&5friend msg [name of the friend] [message]&r &8- &7Send a message to a friend");
        this.set("Friends.CommandUsage.ADD", (Object)"&8/&5friend add [name of the player]&r &8- &7Add a friend");
        this.set("Friends.CommandUsage.Accept", (Object)"&8/&5friend accept [name of the player]&r &8- &7Accept a friend request");
        this.set("Friends.CommandUsage.Deny", (Object)"&8/&5friend deny [name of the player]&r &8- &7Deny a friend request");
        this.set("Friends.CommandUsage.Remove", (Object)"&8/&5friend &5remove &5[name &5of &5the &5friend]&r &8- &7Removes &7a &7friend");
        this.set("Friends.CommandUsage.Jump", (Object)"&8/&5friend jump [name of the friend]&r &8- &7Jump to a friend");
        this.set("Friends.CommandUsage.Settings", (Object)"&8/&5friend settings &r&8- &7Change the settings");
        this.set("Friends.Command.Accept.NowFriends", (Object)" &7You and &e[PLAYER] &7are now friends");
        this.set("Friends.Command.Accept.ErrorNoFriendShipInvitation", (Object)" &7You have not receive a friend request from &e[PLAYER]&7.");
        this.set("Friends.Command.Accept.ErrorSenderEqualsReceiver", (Object)" &7You cannot message yourself.");
        this.set("Friends.Command.Accept.ErrorAlreadySend", (Object)" &7You already have sent the player &e[PLAYER] &7a friend request.");
        this.set("Friends.Command.Add.SenderEqualsReceiver", (Object)" &7You cannot send yourself a friend request.");
        this.set("Friends.Command.Add.FriendRequestFromReceiver", (Object)" &7The player &e[PLAYER] &7has already sent you a friend request.");
        this.set("Friends.Command.Add.FriendRequestReceived", (Object)" &7You have received a friend request from &e[PLAYER]&7.");
        this.set("Friends.Command.Add.ClickHere", (Object)"&aClick here to accept the friend request");
        this.set("Friends.Command.Add.SentAFriendRequest", (Object)" &7The player &e[PLAYER] &7received a friend request from you.");
        this.set("Friends.Command.Add.CanNotSendThisPlayer", (Object)" &7You cannot send the player &e[PLAYER] &7a friend request.");
        this.set("Friends.Command.Add.HowToAccept", (Object)" &7Accept the friend request with &6/friend accept [PLAYER]&7.");
        this.set("Friends.Command.Add.AlreadyFriends", (Object)" &7You and &e[PLAYER] &7are already friends.");
        this.set("Friends.Command.Add.FriendRequestTimedOut", (Object)" &7The Friend request from &e[PLAYER] &7has timed out.");
        this.set("Friends.Command.Deny.HasDenied", (Object)" &7You have denied &e[PLAYER]s&7 friend request.");
        this.set("Friends.Command.Deny.NoFriendRequest", (Object)" &7You have not received a friend request from &e[PLAYER]&7.");
        this.set("Friends.Command.Settings.NowYouCanGetInvitedByEveryone", (Object)" &7Now you can get invited into a party by &aeveryone.");
        this.set("Friends.Command.Settings.NowYouCanGetInvitedByFriends", (Object)" &7Now you can &conly &7get invited into a party by your friends.");
        this.set("Friends.Command.Settings.NowYouAreNotGoneReceiveFriendRequests", (Object)" &7Now you are &cnot going to &7receive friend requests anymore.");
        this.set("Friends.Command.Settings.NowYouAreGoneReceiveFriendRequests", (Object)" &7Now you are &agoing to &7receive friend requests from everyone.");
        this.set("Friends.Command.Settings.NowYouAreNotGoneReceiveMessages", (Object)" &7Now you are &cnot going to &7receive messages anymore.");
        this.set("Friends.Command.Settings.NowYouWillBeShowAsOnline", (Object)" &7Now you will be shown as &aonline.");
        this.set("Friends.Command.Settings.NowYouWilBeShownAsOffline", (Object)" &7Now you will be shown as &coffline.");
        this.set("Friends.Command.Settings.NowYouWillReceiveOnlineStatusNotification", (Object)" &7Now you will &areceive a notification &7when a friend of yours goes online/offline.");
        this.set("Friends.Command.Settings.NowYouWillNotReceiveOnlineStatusNotification", (Object)" &7Now you will &cnot receive a notification &7when a friend of yours goes online/offline.");
        this.set("Friends.Command.Settings.NowNoMessages", (Object)" &7Now you are &cnot going to &7receive messages anymore.");
        this.set("Friends.Command.Settings.NowMessages", (Object)" &7Now you are &agoing to &7receive messages from everyone.");
        this.set("Friends.Command.Settings.NowYourFriendsCanJump", (Object)" &7Now your friends &acan jump &7to you.");
        this.set("Friends.Command.Settings.NowYourFriendsCanNotJump", (Object)" &7Now your friends &ccan not jump &7to you.");
        this.set("Friends.Command.Settings.Introduction", (Object)" &7These are your settings:");
        this.set("Friends.Command.Settings.FriendRequestSettingEveryone", (Object)"&7At the moment you are going to receive friend requests from &aeveryone&7. To change this setting use &6/friend settings friendrequests&7.");
        this.set("Friends.Command.Settings.FriendRequestSettingNobody", (Object)"&7At the moment you are &cnot going to &7receive friend requests. To change this setting use &6/friend settings friendrequests&7.");
        this.set("Friends.Command.Settings.PartyInvitedByEveryone", (Object)"&7At the moment you can get invited into a party by &aevery &7player. To change this setting use &6/friend settings invite&7.");
        this.set("Friends.Command.Settings.PartyInvitedByFriends", (Object)"&7At the moment you can get invited &conly &7by your friends into their Party. To change this setting use &6/friend settings invite&7.");
        this.set("Friends.Command.Settings.CanJump", (Object)"&7At the moment your friends &acan jump to you&7. To change this setting use &6/friend settings jump&7.");
        this.set("Friends.Command.Settings.CanNotJump", (Object)"&7At the moment your friends &ccannot &7jump to you. To change this setting use &6/friend settings jump&7.");
        this.set("Friends.Command.Settings.ShowAsOnline", (Object)"&7At the moment you are shown as &aonline&7. To change this setting use &6/friend settings offline&7.");
        this.set("Friends.Command.Settings.ShowAsOffline", (Object)"&7At the moment you are shown as &coffline&7. To change this setting use &6/friend settings offline&7.");
        this.set("Friends.Command.Settings.ShowOnlineStatusChangeNotification", (Object)"&7At the moment you are &areceiving &7a notification if the online status of a friend changes. To change this setting use &6/friend settings notifyonline&7.");
        this.set("Friends.Command.Settings.DoNotShowOnlineStatusChangeNotification", (Object)"&7At the moment you are shown as &cnot receiving &7a notification if the online status of a friend changes. To change this setting use &6/friend settings notifyonline&7.");
        this.set("Friends.Command.Settings.ReceivePM", (Object)"&7At the moment you are able to &areceive &7private messages. To change this setting use &6/friend settings message&7.");
        this.set("Friends.Command.Settings.DoNotReceivePM", (Object)"&7At the moment you are &cnot &7able to receive private messages. To change this setting use &6/friend settings message&7.");
        this.set("Friends.Command.Settings.ChangeThisSettingsHover", (Object)"&aClick here to change this setting.");
        this.set("Friends.Command.Settings.NotFound", (Object)" &7The setting which was specified could not be found or you don't have the permission to use this setting.");
        this.set("Friends.Command.Jump.AlreadyOnTheServer", (Object)" &7You are already on this server.");
        this.set("Friends.Command.Jump.JoinedTheServer", (Object)" &7Now you are on the same server, like the player &e[PLAYER]&7.");
        this.set("Friends.Command.Jump.CanNotJump", (Object)" &7You cannot jump to this person.");
        this.set("Friends.Command.List.NoFriendsAdded", (Object)" &7You currently do not have any friends.");
        this.set("Friends.Command.List.FriendsList", (Object)" &7These are your friends:LINE_BREAK &7- ");
        this.set("Friends.Command.List.PageDoesNotExist", (Object)" &7The given page does not exist.");
        this.set("Friends.Command.List.NextPage", (Object)" &7To see more friends use /friend list [PAGE].");
        this.set("Friends.Command.List.OnlineTitle", (Object)" &a(online)&7, currently playing on [SERVER_ON]");
        this.set("Friends.Command.List.OfflineTitle", (Object)" &c(offline)&7, last seen at [LAST_ONLINE]");
        this.set("Friends.Command.List.TimeColor", (Object)"&7");
        this.set("Friends.Command.MSG.CanNotWriteToHim", (Object)" &7You cannot message this player.");
        this.set("Friends.Command.MSG.NoOneEverWroteToYou", (Object)" &7You have not received any messages before.");
        this.set("Friends.Command.MSG.MessageMissing", (Object)" &7You need to give a message.");
        this.set("Friends.Command.MSG.PlayerWillReceiveMessageOnJoin", (Object)" &7The player will receive the message when he goes online.");
        this.set("Friends.Command.Remove.Removed", (Object)" &7You removed the friend &e[PLAYER]&7.");
        this.set("Friends.Command.Remove.FriendRemovedYou", (Object)" &e[PLAYER]&7 removed you from his friend list.");
        this.set("PAFAdmin.Command.DeletePlayer.PlayerDeleted", (Object)" &7All data saved by Party and Friends of the player &e[PLAYER]&7 were deleted.");
        this.set("PAFAdmin.Command.MustBeExecutedByConsole", (Object)"&cThis command needs to be executed by the console. This message can be changed in the messages.yml under \"AdminCommands.TopCommand.PlayerMessage\", if UseOwnLanguageFile is activated in the config.yml.");
    }

    private void loadGermanMessages() {
        this.set("General.DisabledServer", (Object)"&cDieses Kommando kann hier nicht ausgef\u00fchrt werden.");
        this.set("General.UnableToConnectToServerRedisBungee", (Object)"&cDer Server konnte nicht betreten werden.");
        this.set("Friends.Command.Add.SentAFriendRequest", (Object)" &7Dem Spieler &e[PLAYER] &7wurde eine Freundschaftsanfrage gesendet.");
        this.set("Friends.General.CommandNotFound", (Object)" &cDas Kommando existiert nicht.");
        this.set("Friends.General.NoPermission", (Object)" &cDu hast nicht die Permssion um dieses Kommando auszuf\u00fchren.");
        this.set("Friends.General.PlayerIsOffline", (Object)" &7Der Spieler &e[PLAYER] &7ist nicht online oder du bist nicht mit ihm befreundet.");
        this.set("Friends.General.NotAFriendOfOrOffline", (Object)" &7Der Spieler &e[PLAYER] &7ist nicht online oder kein Freund von dir.");
        this.set("Friends.General.NoPlayerGiven", (Object)" &7Du musst einen Spieler angeben.");
        this.set("Friends.General.NoFriendGiven", (Object)" &7Es wurde kein Freund angegeben.");
        this.set("Friends.General.PlayerIsNowOnline", (Object)" &e[PLAYER] &7ist jetzt &aonline&7.");
        this.set("Friends.General.RequestInfoOnJoin", (Object)" &7Freundschaftsanfragen stehen von den folgenden Spielern aus: [FRIENDREQUESTS]");
        this.set("Friends.General.PlayerIsNowOffline", (Object)" &7Der Freund &e[PLAYER] &7ist nun &coffline&7.");
        this.set("Friends.General.DoesNotExist", (Object)" &7Der gegebene Spieler existiert nicht.");
        this.set("Friends.General.GivenPlayerEqualsSender", (Object)" &7Du kannst dich nicht selber als Spieler Argument angeben.");
        this.set("Friends.CommandUsage.List", (Object)"&8/&5friend list&r &8- &7Listet deine Freunde auf");
        this.set("Friends.CommandUsage.MSG", (Object)"&8/&5friend msg [Name des Freundes] [Nachricht]&r &8- &7schickt einem Freund eine private Nachricht");
        this.set("Friends.CommandUsage.ADD", (Object)"&8/&5friend add [Name des Spielers]&r &8- &7F\u00fcgt einen Freund hinzu");
        this.set("Friends.CommandUsage.Accept", (Object)"&8/&5friend accept [Name des Spielers]&r &8- &7Akzeptiert eine Freundschaftsanfrage");
        this.set("Friends.CommandUsage.Deny", (Object)"&8/&5friend deny [Name des Spielers]&r &8- &7Lehnt eine Freundschaftsanfrage ab");
        this.set("Friends.CommandUsage.Remove", (Object)"&8/&5friend remove [Name des Spielers]&r &8- &7Entfernt einen Freund");
        this.set("Friends.CommandUsage.Jump", (Object)"&8/&5friend jump [Name des Freundes]&r&8- &7Zu einem Freund springen");
        this.set("Friends.CommandUsage.Settings", (Object)"&8/&5friend settings &r&8- &7\u00c4ndere die Einstellungen");
        this.set("Friends.Command.Accept.NowFriends", (Object)" &7Du bist jetzt mit &e[PLAYER] &7befreundet.");
        this.set("Friends.Command.Accept.ErrorAlreadySend", (Object)" &7Du hast dem Spieler &e[PLAYER] &7bereits eine Freundschaftsanfrage gesendet.");
        this.set("Friends.Command.Accept.ErrorNoFriendShipInvitation", (Object)" &7Du hast keine Freundschaftsanfrage von &e[PLAYER] &7erhalten.");
        this.set("Friends.Command.Add.FriendRequestFromReceiver", (Object)" &7Der Spieler &e[PLAYER] &7hat dir schon eine Freundschaftsanfrage gesendet.");
        this.set("Friends.Command.Add.FriendRequestReceived", (Object)" &7Du hast eine Freundschaftsanfrage von &e[PLAYER]&7 erhalten.");
        this.set("Friends.Command.Add.HowToAccept", (Object)" &7Nimm sie mit &6/friend accept [PLAYER] &7an.");
        this.set("Friends.Command.Add.ClickHere", (Object)"&aHier klicken um die Freundschaftsanfrage anzunehmen");
        this.set("Friends.Command.Add.AlreadyFriends", (Object)" &7Du bist schon mit &e[PLAYER] &7befreundet.");
        this.set("Friends.Command.Add.CanNotSendThisPlayer", (Object)" &7Du kannst dem Spieler &e[PLAYER] &7keine Freundschaftsanfrage senden.");
        this.set("Friends.Command.Add.SenderEqualsReceiver", (Object)" &7Du kannst dir nicht selbst eine Freundschaftsanfrage schicken.");
        this.set("Friends.Command.Add.FriendRequestTimedOut", (Object)" &7Die Freundschaftsanfrage von &e[PLAYER] &7ist ausgetimet.");
        this.set("Friends.Command.Accept.ErrorSenderEqualsReceiver", (Object)" &7Du kannst dir nicht selber eine Freundschaftsanfrage senden.");
        this.set("Friends.Command.Deny.HasDenied", (Object)" &7Du hast die Anfrage von &e[PLAYER] &7abgelehnt.");
        this.set("Friends.Command.Jump.CanNotJump", (Object)" &7Du kannst nicht zu dieser Person springen.");
        this.set("Friends.Command.Jump.AlreadyOnTheServer", (Object)" &7Du bist bereits auf diesem Server.");
        this.set("Friends.Command.Jump.JoinedTheServer", (Object)" &7Du bist jetzt auf dem gleichen Server wie der Spieler &e[PLAYER]&7.");
        this.set("Friends.Command.List.FriendsList", (Object)" &7Dies sind deine Freunde:LINE_BREAK &7- ");
        this.set("Friends.Command.List.PageDoesNotExist", (Object)" &7Diese Seite existiert nicht.");
        this.set("Friends.Command.List.NextPage", (Object)" &7Um mehr Freunde zu sehen nutze /friend list [PAGE].");
        this.set("Friends.Command.List.NoFriendsAdded", (Object)" &7Du hast noch keine Freunde hinzugef\u00fcgt.");
        this.set("Friends.Command.List.OnlineTitle", (Object)" &a(online)&7, spielt gerade auf [SERVER_ON]");
        this.set("Friends.Command.List.OfflineTitle", (Object)" &c(offline)&7, zuletzt online [LAST_ONLINE]");
        this.set("Friends.Command.Remove.Removed", (Object)" &7Du hast den Freund &e[PLAYER] &7entfernt.");
        this.set("Friends.Command.Remove.FriendRemovedYou", (Object)" &e[PLAYER]&7 hat dich von seiner Freundesliste entfernt.");
        this.set("Friends.Command.Settings.Introduction", (Object)" &7Dies sind deine Einstellungen:");
        this.set("Friends.Command.Settings.FriendRequestSettingEveryone", (Object)"&7Momentan erh\u00e4lst du Freundschaftsanfragen von &ajedem&7. Um dies zu \u00e4ndern nutze &6/friend settings friendrequests&7.");
        this.set("Friends.Command.Settings.FriendRequestSettingNobody", (Object)"&7Momentan k\u00f6nnen dir &ckeine &7Freundschaftsanfragen gesendet werden. Um dies zu \u00e4ndern nutze &6/friend settings friendrequests&7.");
        this.set("Friends.Command.Settings.PartyInvitedByEveryone", (Object)"&7Momentan k\u00f6nnen dir Partyeinladungen von &ajedem &7gesendet werden gesendet werden. Um dies zu \u00e4ndern nutze &6/friend settings invite&7.");
        this.set("Friends.Command.Settings.PartyInvitedByFriends", (Object)"&7Momentan kannst du &cnur &7von deinen Freunden in eine Party eingeladen werden. Um dies zu \u00e4ndern nutze &6/friend settings invite&7.");
        this.set("Friends.Command.Settings.CanJump", (Object)"&7Momentan &ak\u00f6nnen &7deine Freunde zu dir Springen. Um dies zu \u00e4ndern nutze &6/friend settings jump&7.");
        this.set("Friends.Command.Settings.CanNotJump", (Object)"&7Momentan k\u00f6nnen deine Freunde &cnicht &7zu dir springen. Um dies zu \u00e4ndern nutze &6/friend settings jump&7.");
        this.set("Friends.Command.Settings.ShowAsOnline", (Object)"&7Momentan wirst du als &aOnline&7 angezeigt. Um dies zu \u00e4ndern nutze &6/friend settings offline&7.");
        this.set("Friends.Command.Settings.ShowAsOffline", (Object)"&7Momentan wirst du als &cOffline&7 angezeigt. Um dies zu \u00e4ndern nutze &6/friend settings offline&7.");
        this.set("Friends.Command.Settings.ShowOnlineStatusChangeNotification", (Object)"&7Momentan &aerh\u00e4lst du eine Benachrichtigung&7, wenn ein Freund Online/Offline geht. Um dies zu \u00e4ndern nutze &6/friend settings notifyonline&7.");
        this.set("Friends.Command.Settings.DoNotShowOnlineStatusChangeNotification", (Object)"&7Momentan &cerh\u00e4lst du keine Benachrichtigung&7, wenn ein Freund Online/Offline geht. Um dies zu \u00e4ndern nutze &6/friend settings notifyonline&7.");
        this.set("Friends.Command.Settings.ReceivePM", (Object)"&7Momentan &aerh\u00e4lst &7du private Nachrichten. Um dies zu \u00e4ndern nutze &6/friend settings message&7.");
        this.set("Friends.Command.Settings.DoNotReceivePM", (Object)"&7Momentan erh\u00e4lst du &ckeine &7private Nachrichten. Um dies zu \u00e4ndern nutze &6/friend settings message&7.");
        this.set("Friends.Command.Settings.NotFound", (Object)" &7Die gegebene Einstellung konnte nicht gefunden werden oder du hast nicht die Rechte um diese zu benutzen.");
        this.set("Friends.Command.Settings.ChangeThisSettingsHover", (Object)"&aHier klicken um die Einstellung zu \u00e4ndern.");
        this.set("Friends.Command.Settings.NowYouCanGetInvitedByEveryone", (Object)" &7Du kannst jetzt von &ajedem &7Spieler in eine Party eingeladen werden.");
        this.set("Friends.Command.Settings.NowYouCanGetInvitedByFriends", (Object)" &7Du kannst jetzt &cnur &7noch von deinen Freunden in eine Party eingeladen werden.");
        this.set("Friends.Command.Settings.NowYouAreNotGoneReceiveFriendRequests", (Object)" &7Du kannst jetzt &ckeine &7Freundschaftsanfragen mehr erhalten.");
        this.set("Friends.Command.Settings.NowYouAreGoneReceiveFriendRequests", (Object)" &7Du kannst jetzt von &ajedem &7Freundschaftsanfragen erhalten.");
        this.set("Friends.Command.Settings.NowYouAreNotGoneReceiveMessages", (Object)" &7Nun wirst du &ckeine &7Nachrichten mehr erhalten.");
        this.set("Friends.Command.Settings.NowYouWillBeShowAsOnline", (Object)" &7Du wirst nun als &aonline &7angezeigt.");
        this.set("Friends.Command.Settings.NowYouWilBeShownAsOffline", (Object)" &7Du wirst nun als &coffline &7angezeigt.");
        this.set("Friends.Command.Settings.NowYouWillReceiveOnlineStatusNotification", (Object)" &7Du &aerh\u00e4lst nun eine Benachrichtigung&7, wenn ein Freund Online/Offline geht.");
        this.set("Friends.Command.Settings.NowYouWillNotReceiveOnlineStatusNotification", (Object)" &7Du &cerh\u00e4lst nun keine Benachrichtigung mehr&7, wenn ein Freund Online/Offline geht.");
        this.set("Friends.Command.Settings.NowNoMessages", (Object)" &7Du kannst jetzt &ckeine &7Nachrichten mehr erhalten.");
        this.set("Friends.Command.Settings.NowMessages", (Object)" &7Du kannst jetzt von &ajedem &7Nachrichten erhalten.");
        this.set("Friends.Command.Settings.NowYourFriendsCanJump", (Object)" &7Freunde k\u00f6nnen jetzt zu dir &aspringen&7.");
        this.set("Friends.Command.Settings.NowYourFriendsCanNotJump", (Object)" &7Freunde k\u00f6nnen jetzt &cnicht &7zu dir springen.");
        this.set("Friends.Command.MSG.CanNotWriteToHim", (Object)" &7Du kannst diesem Spieler nicht schreiben.");
        this.set("Friends.Command.MSG.PlayerWillReceiveMessageOnJoin", (Object)" &7Der Spieler erh\u00e4lt die Nachricht, sobald er online geht.");
        this.set("Friends.Command.MSG.NoOneEverWroteToYou", (Object)" &7Noch kein Spieler hat dich angeschrieben.");
        this.set("Friends.Command.MSG.MessageMissing", (Object)" &7Du hast keine Nachricht angegeben.");
        this.set("Party.Command.Leader.SenderEqualsGivenPlayer", (Object)"&7Du kannst dich nicht selber zum neuen Party Leader machen.");
        this.set("Party.General.ErrorGivenPlayerIsNotInTheParty", (Object)"&cDer Spieler &e[PLAYER] &7ist nicht in der Party.");
        this.set("Party.CommandUsage.Join", (Object)"&8/&5Party join <Name> &8- &7Trete einer Party bei");
        this.set("Party.CommandUsage.Deny", (Object)"&8/&5Party deny  &8- &7Lehne eine Einladung ab");
        this.set("Party.CommandUsage.Invite", (Object)"&8/&5Party invite <Name> &8- &7Lade einen Spieler in deine Party ein");
        this.set("Party.CommandUsage.InviteSetting", (Object)"&8/&5Party setting  &8- &7Aktiviert/deaktiviert Party Einladungen");
        this.set("Party.CommandUsage.List", (Object)"&8/&5Party list &8- &7Listet alle Spieler in der Party auf");
        this.set("Party.CommandUsage.Chat", (Object)"&8/&5Party chat <Nachricht> &8- &7Sendet allen Spieler in der Party eine Nachicht");
        this.set("Party.CommandUsage.Leave", (Object)"&8/&5Party leave &8- &7Verl\u00e4sst die Party");
        this.set("Party.CommandUsage.Kick", (Object)"&8/&5Party kick <Spieler> &8- &7Kickt einen Spieler aus der Party");
        this.set("Party.CommandUsage.Leader", (Object)"&8/&5Party leader <Spieler> &8- &7Macht einen anderen Spieler zum Leader");
        this.set("Party.Error.CommandNotFound", (Object)"&cDieser Befehl existiert nicht!");
        this.set("Party.Error.NoPermission", (Object)"&cDu hast nicht die Permssion um dieses Kommando auszuf\u00fchren!");
        this.set("Party.Command.General.PlayerHasLeftTheParty", (Object)"&bDer Spieler &6[PLAYER] hat die Party verlassen.");
        this.set("Party.Command.General.ErrorNoParty", (Object)"&cDu bist in keiner Party.");
        this.set("Party.Command.General.ErrorNotPartyLeader", (Object)"&cDu bist nicht der Party Leader.");
        this.set("Party.Command.General.ErrorGivenPlayerIsNotInTheParty", (Object)"&cDer Spieler &e[PLAYER] &cist nicht in der Party.");
        this.set("Party.Command.General.ErrorNoPlayer", (Object)"&cDu musst einen Spieler angeben.");
        this.set("Party.Command.General.ErrorPlayerNotOnline", (Object)"&cDieser Spieler ist nicht online.");
        this.set("Party.Command.General.DissolvedPartyCauseOfNotEnoughPlayers", (Object)"&5Die Party wurde wegen zu wenig Mitgliedern aufgel\u00f6st.");
        this.set("Party.Command.General.ServerSwitched", (Object)"&bDie Party hat den Server &e[SERVER] &bbetreten.");
        this.set("Party.Command.Chat.ErrorNoMessage", (Object)"&5Du musst eine Nachricht eingeben.");
        this.set("Party.Command.Info.Empty", (Object)"Leer");
        this.set("Party.Command.Invite.CanNotInviteThisPlayer", (Object)"&cDieser Spieler ist nicht online.");
        this.set("Party.Command.Invite.GivenPlayerEqualsSender", (Object)"&7Du darfst dich nicht selber einladen.");
        this.set("Party.Command.Invite.AlreadyInAParty", (Object)"&cDieser Spieler ist bereits in einer Party.");
        this.set("Party.Command.Invite.AlreadyInYourParty", (Object)"&cDieser Spieler &e[PLAYER] &cist schon in die Party eingeladen.");
        this.set("Party.Command.Invite.MaxPlayersInPartyReached", (Object)"&cDie maximale Gr\u00f6\u00dfe f\u00fcr eine Party ist [MAXPLAYERSINPARTY].");
        this.set("Party.Command.Invite.InvitedPlayer", (Object)"&bDu hast &6[PLAYER] &bin deine Party eingeladen.");
        this.set("Party.Command.Invite.InvitationTimedOutInvited", (Object)"&5Die Einladung in die Party von &6[PLAYER] &5ist abgelaufen!");
        this.set("Party.Command.Invite.InvitationTimedOutLeader", (Object)"&5Der Spieler &6[PLAYER] &5hat die Einladung nicht angenommen!");
        this.set("Party.Command.Join.PlayerHasNoParty", (Object)"&cDieser Spieler hat keine Party.");
        this.set("Party.Command.Join.AlreadyInAPartyError", (Object)"&cDu bist bereits in einer Party. Nutze &6/party leave &cum diese Party zu verlassen.");
        this.set("Party.Command.Join.PlayerHasJoined", (Object)"&bDer Spieler &6[PLAYER] &bist der Party beigetreten.");
        this.set("Party.Command.Join.ErrorNoInvitation", (Object)"&cDu kannst der Party nicht beitreten.");
        this.set("Party.Command.Deny.PlayerHasNoParty", (Object)"&cDieser Spieler hat keine Party.");
        this.set("Party.Command.Deny.PlayerHasDeniedInvitation", (Object)"&bDer Spieler &6[PLAYER] &bhat die Einladung abgelehnt.");
        this.set("Party.Command.Deny.DeniedInvitation", (Object)"&bDu hast die Party Einladung abgelehnt.");
        this.set("Party.Command.Deny.ErrorNoInvitation", (Object)"&cDu kannst der Party nicht beitreten.");
        this.set("Party.Command.Kick.KickedPlayerOutOfThePartyOthers", (Object)"&bDer Spieler &6[PLAYER] &bwurde aus der Party gekickt.");
        this.set("Party.Command.Kick.KickedPlayerOutOfThePartyKickedPlayer", (Object)"&bDu wurdest aus der Party gekickt.");
        this.set("Party.Command.Kick.Party.Command.Leader.NewLeaderIs", (Object)"&7Der neue Party Leader ist &6[NEWLEADER].");
        this.set("Party.Command.Leader.NewLeaderIs", (Object)"&7Der neue Party Leader ist &6[NEWLEADER].");
        this.set("Party.Command.Leave.YouLeftTheParty", (Object)"&bDu hast deine Party verlassen.");
        this.set("Party.Command.Leave.NewLeaderIs", (Object)"&bDer Leader hat die Party verlassen. Der neue Leader ist &e[NEWLEADER].");
        this.set("Party.Command.Invite.AcceptInvite", (Object)"&aTritt der Party mit &6/party join [PLAYER] &abei!");
        this.set("Party.Command.Invite.AcceptInviteHOVER", (Object)"&aHier klicken um die Partyeinladung anzunehmen");
        this.set("Party.Command.Invite.DeclineInvite", (Object)"&cLehne die Einladung mit &6/Party &6deny &6[PLAYER]&5 &cab!");
        this.set("Party.Command.Invite.DeclineInviteHOVER", (Object)"&cHier klicken um die Partyeinladung abzulehnen");
        this.set("Party.Command.Invite.YouWereInvitedBY", (Object)"&5Du wurdest in die Party von &6[PLAYER] &5eingeladen!");
    }

    private void loadSharedMessages() {
        this.set("Friends.General.Prefix", (Object)"&8[&5&lFriends&8]");
        this.set("Party.General.PartyPrefix", (Object)"&7[&5Party&7] ");
        this.set("Friends.General.HelpBegin", (Object)"&8&m-------------------&r&8[&5&lFriends&8]&m-------------------");
        this.set("Friends.General.HelpEnd", (Object)"&8&m-----------------------------------------------");
        this.set("Party.General.HelpBegin", (Object)"&8&m-------------------&r&8[&5&lParty&8]&m-------------------");
        this.set("Party.General.HelpEnd", (Object)"&8&m---------------------------------------------");
        this.set("Party.Command.Chat.Prefix", (Object)"&7[&5PartyChat&7] ");
        this.set("Party.Command.Chat.ContentColor", (Object)"&7");
        this.set("Party.Command.Chat.PartyChatOutput", (Object)"&e[SENDERNAME]&5:[MESSAGE_CONTENT]");
        this.set("Party.Command.Info.PlayersCut", (Object)"&7, &b");
        this.set("Party.Command.Info.Leader", (Object)"&3Leader&7: &5[LEADER]");
        this.set("Party.Command.Info.Players", (Object)"&8Players&7: &b");
        this.set("Friends.General.RequestInfoOnJoinColor", (Object)"&e");
        this.set("Friends.General.RequestInfoOnJoinColorComma", (Object)"&7");
        this.set("Friends.Command.MSG.SentMessage", (Object)" &e[SENDERNAME] &5-> &e[PLAYER]&7:[CONTENT]");
        this.set("Friends.Command.List.OnlineColor", (Object)"&a");
        this.set("Friends.Command.List.OfflineColor", (Object)"&c");
        this.set("Friends.Command.List.PlayerSplit", (Object)"LINE_BREAK &7- ");
        this.set("Friends.Command.MSG.ColorOfMessage", (Object)" &7");
        this.set("Friends.Command.Settings.SplitLine", (Object)"&8&m-----------------------------------------------");
    }

    @Override
    public void reloadConfiguration() throws IOException {
        this.configuration = new MessagesLoader(this.LANGUAGE, this.USE_CUSTOM_MESSAGES, this.FILE, Main.getInstance()).getCreatedConfiguration();
    }
}

