/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.utilities;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.main.Main;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.md_5.bungee.api.config.ServerInfo;

public class PlayerListElement
implements Comparable<PlayerListElement> {
    private final boolean IS_ONLINE;
    private final Long LAST_ONLINE;
    private final ServerInfo SERVER;
    private final PAFPlayer PLAYER;
    private String displayName = null;
    private String name;
    private UUID uuid;
    private final int SORT_TYPE;
    private final OnlinePAFPlayer CALLER;

    public PlayerListElement(PAFPlayer pPlayer) {
        this(pPlayer, 0, null);
    }

    private PlayerListElement(PAFPlayer pPlayer, int pSortingType, OnlinePAFPlayer pCaller) {
        boolean isOnline;
        this.PLAYER = pPlayer;
        this.IS_ONLINE = isOnline = pPlayer.isOnline() && (!Main.getInstance().getGeneralConfig().getBoolean("Commands.Friends.SubCommands.Settings.Settings.Offline.Enabled") || pPlayer.getSettingsWorth(3) == 0);
        if (!isOnline) {
            this.LAST_ONLINE = pPlayer.getLastOnline();
            this.SERVER = null;
        } else {
            this.LAST_ONLINE = null;
            this.SERVER = ((OnlinePAFPlayer)pPlayer).getServer();
        }
        this.CALLER = pCaller;
        this.SORT_TYPE = pSortingType == 2 && pCaller == null ? 0 : pSortingType;
    }

    @Override
    public int compareTo(PlayerListElement pCompare) {
        int sortType = 0;
        if (pCompare.SORT_TYPE == this.SORT_TYPE) {
            sortType = this.SORT_TYPE;
        }
        switch (sortType) {
            case 1: {
                return -pCompare.getName().toLowerCase().compareTo(this.getName().toLowerCase());
            }
            case 2: {
                return pCompare.getName().toLowerCase().compareTo(this.getName().toLowerCase());
            }
            case 3: {
                return 0;
            }
        }
        return this.defaultCompareTo(pCompare);
    }

    private int defaultCompareTo(PlayerListElement pCompare) {
        if (pCompare.isOnline() && this.isOnline()) {
            return this.getName().compareTo(pCompare.getName());
        }
        if (pCompare.isOnline()) {
            return 1;
        }
        if (this.isOnline()) {
            return -1;
        }
        switch (this.LAST_ONLINE.compareTo(pCompare.LAST_ONLINE)) {
            case 1: {
                return -1;
            }
            case -1: {
                return 1;
            }
        }
        return 0;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.PLAYER.getDisplayName();
            return this.displayName;
        }
        return this.displayName;
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.PLAYER.getName();
            return this.name;
        }
        return this.name;
    }

    public UUID getUniqueId() {
        if (this.uuid == null) {
            this.uuid = this.PLAYER.getUniqueId();
            return this.uuid;
        }
        return this.uuid;
    }

    public boolean isOnline() {
        return this.IS_ONLINE;
    }

    public Long getLastOnline() {
        return this.LAST_ONLINE;
    }

    public ServerInfo getServer() {
        return this.SERVER;
    }

    public PAFPlayer getPlayer() {
        return this.PLAYER;
    }

    public static List<PlayerListElement> getFriendsAsPlayerListElement(OnlinePAFPlayer pCaller, int pSortType) {
        List<PAFPlayer> friends = pCaller.getFriends();
        ArrayList<PlayerListElement> playerListElements = new ArrayList<PlayerListElement>(friends.size());
        for (PAFPlayer player : friends) {
            playerListElements.add(new PlayerListElement(player, pSortType, pCaller));
        }
        return playerListElements;
    }
}

