/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.utilities;

import de.simonsator.partyandfriends.utilities.ConfigurationCreator;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.config.ServerInfo;

public class ServerDisplayNameCollection {
    private static ServerDisplayNameCollection instance;
    private final Map<String, String> serverNames;

    public ServerDisplayNameCollection(ConfigurationCreator pConfig) {
        instance = this;
        if (pConfig.getBoolean("ServerDisplayNames.Use")) {
            this.serverNames = new HashMap<String, String>();
            for (String key : pConfig.getSectionKeys("ServerDisplayNames.Replace")) {
                this.serverNames.put(pConfig.getString("ServerDisplayNames.Replace." + key + ".RealName"), pConfig.getString("ServerDisplayNames.Replace." + key + ".ReplacedName"));
            }
        } else {
            this.serverNames = null;
        }
    }

    public static ServerDisplayNameCollection getInstance() {
        return instance;
    }

    public String getServerDisplayName(ServerInfo pServerInfo) {
        if (pServerInfo == null) {
            return "?";
        }
        if (this.serverNames == null) {
            return pServerInfo.getName();
        }
        String serverDisplayName = this.serverNames.get(pServerInfo.getName());
        if (serverDisplayName == null) {
            return pServerInfo.getName();
        }
        return serverDisplayName;
    }
}

