/*
 * Decompiled with CFR 0.152.
 */
package de.simonsator.partyandfriends.utilities;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.main.Main;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.api.chat.TextComponent;

public abstract class SubCommand
implements Comparable<SubCommand> {
    public final TextComponent HELP;
    protected final String PREFIX;
    private final ArrayList<String> commands;
    private final int PRIORITY;
    private final String PERMISSION;

    protected SubCommand(String[] pCommands, int pPriority, TextComponent pHelp, String pPrefix) {
        this.HELP = pHelp;
        this.PRIORITY = pPriority;
        this.PREFIX = pPrefix;
        this.PERMISSION = null;
        this.commands = new ArrayList(pCommands.length);
        for (String command : pCommands) {
            this.commands.add(command.toLowerCase());
        }
    }

    protected SubCommand(String[] pCommands, int pPriority, String pHelp, String pPrefix) {
        this.HELP = new TextComponent(pHelp);
        this.PRIORITY = pPriority;
        this.PREFIX = pPrefix;
        this.PERMISSION = null;
        this.commands = new ArrayList(pCommands.length);
        for (String command : pCommands) {
            this.commands.add(command.toLowerCase());
        }
    }

    protected SubCommand(List<String> pCommands, int pPriority, String pHelp, String pPrefix, String pPermission) {
        this.HELP = new TextComponent(pHelp);
        this.PRIORITY = pPriority;
        this.PREFIX = pPrefix;
        this.PERMISSION = pPermission;
        this.commands = new ArrayList(pCommands.size());
        for (String command : pCommands) {
            this.commands.add(command.toLowerCase());
        }
    }

    public boolean isApplicable(String pCommand) {
        return this.commands.contains(pCommand.toLowerCase());
    }

    public boolean isApplicable(OnlinePAFPlayer pPlayer, String pCommand) {
        return this.isApplicable(pCommand) && this.hasPermission(pPlayer);
    }

    public void sendError(OnlinePAFPlayer pPlayer, TextComponent pMessage) {
        pPlayer.sendMessage(pMessage);
        pPlayer.sendMessage(this.HELP);
    }

    public void sendError(OnlinePAFPlayer pPlayer, String pIdentifier) {
        this.sendError(pPlayer, new TextComponent(this.PREFIX + Main.getInstance().getMessages().getString(pIdentifier)));
    }

    public abstract void onCommand(OnlinePAFPlayer var1, String[] var2);

    @Override
    public int compareTo(SubCommand o) {
        return Integer.compare(this.PRIORITY, o.PRIORITY);
    }

    public String getCommandName() {
        return this.commands.get(0);
    }

    public ArrayList<String> getCommandNames() {
        return this.commands;
    }

    public void printOutHelp(OnlinePAFPlayer pPlayer, String pCommandName) {
        pPlayer.sendMessage(this.HELP.getText());
    }

    public boolean hasPermission(OnlinePAFPlayer pPlayer) {
        return pPlayer.hasPermission(this.PERMISSION);
    }
}

