package de.simonsator.partyandfriends.clan;

import de.simonsator.partyandfriends.communication.sql.MySQLData;
import de.simonsator.partyandfriends.communication.sql.SQLCommunication;

import java.sql.*;
import java.util.ArrayList;

public class ClanConnection extends SQLCommunication {


	public ClanConnection(String pHost, String pUsername, String pPassword, int pPort, String pDatabase) {
		super(pDatabase, "jdbc:mysql://" + pHost + ":" + pPort, pUsername, pPassword);
		importClan();
	}

	public ClanConnection(MySQLData pMySQLData) {
		super(pMySQLData.DATABASE, "jdbc:mysql://" + pMySQLData.HOST + ":" + pMySQLData.PORT, pMySQLData.USERNAME, pMySQLData.PASSWORD);
		importClan();
	}


	private void importClan() {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + DATABASE
					+ ".`clan` (`clan_name` varchar(16) NOT NULL,\n" + "`clan_tag` varchar(4) NOT NULL,\n"
					+ "`id` int(7) NOT NULL AUTO_INCREMENT, PRIMARY KEY (`id`))");
			prepStmt.executeUpdate();
			prepStmt.close();
			prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + DATABASE
					+ ".`clans_assignment` (`player_id` INT(8) NOT NULL, `clan_id` INT(7) NOT NULL,"
					+ " `type` TINYINT(1) NOT NULL);");
			prepStmt.executeUpdate();
			prepStmt.close();
			prepStmt = con.prepareStatement("CREATE TABLE IF NOT EXISTS " + DATABASE
					+ ".`clans_request_assignment` (`player_id` INT(8) NULL, `clan_id` INT(8) NULL);");
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public int getClanByID(int pPlayerID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery("select clan_id from " + DATABASE
					+ ".clans_assignment WHERE player_id='" + pPlayerID + "' LIMIT 1");
			if (rs.next()) {
				return rs.getInt("clan_id");
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return 0;
	}

	public boolean isInvited(int pPlayerID, int pClanID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement())
					.executeQuery("select clan_id from " + DATABASE + ".clans_request_assignment WHERE player_id='"
							+ pPlayerID + "' AND clan_id='" + pClanID + "' LIMIT 1");
			if (rs.next())
				return true;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return false;
	}

	public ArrayList<Integer> getRequests(int pPlayerID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		ArrayList<Integer> clanRequests = new ArrayList<>();
		try {
			rs = (stmt = con.createStatement()).executeQuery("select clan_id from " + DATABASE
					+ ".clans_request_assignment WHERE player_id='" + pPlayerID + "'");
			while (rs.next())
				clanRequests.add(rs.getInt("clan_id"));
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return clanRequests;
	}

	public boolean hasRequests(int pPlayerID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery("select clan_id from " + DATABASE
					+ ".clans_request_assignment WHERE player_id='" + pPlayerID + "' LIMIT 1");
			if (rs.next())
				return true;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return false;
	}

	public ArrayList<Integer> getRequestedPlayers(int pClanID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		ArrayList<Integer> requested = new ArrayList<>();
		try {
			rs = (stmt = con.createStatement()).executeQuery("select player_id from " + DATABASE
					+ ".clans_request_assignment WHERE clan_id='" + pClanID + "'");
			while (rs.next())
				requested.add(rs.getInt("player_id"));
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return requested;
	}


	public int createClan(int pLeader, String pClanName, String pClanTag) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		ResultSet rs = null;
		try {
			prepStmt = con.prepareStatement("insert into  " + DATABASE + ".clan values (?, ?, ?)",
					Statement.RETURN_GENERATED_KEYS);
			prepStmt.setString(1, pClanName);
			prepStmt.setString(2, pClanTag);
			prepStmt.setNull(3, 5);
			prepStmt.executeUpdate();
			rs = prepStmt.getGeneratedKeys();
			int clanID = 0;
			if (rs.next()) {
				clanID = rs.getInt(1);
				setClan(pLeader, clanID, (byte) 1);
			}
			return clanID;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, prepStmt);
		}
		return 0;
	}

	public void setClan(int pPlayer, int pClanID, byte pType) {
		removeClanAssignment(pPlayer, pClanID);
		if (pClanID == 0)
			return;
		addToClanAssignment(pPlayer, pClanID, pType);
	}

	private void addToClanAssignment(int pPlayer, int pClanID, byte pType) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("insert into " + DATABASE + ".clans_assignment values (?, ?, ?)");
			prepStmt.setInt(1, pPlayer);
			prepStmt.setInt(2, pClanID);
			prepStmt.setByte(3, pType);
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public void removeClanAssignment(int pPlayer, int pClanID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("DELETE FROM " + DATABASE + ".clans_assignment WHERE player_id = '"
					+ pPlayer + "' AND clan_id='" + pClanID + "'");
			prepStmt.execute();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public void inviteIntoClan(int pClan, int pInvitedPlayerID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("insert into  " + DATABASE + ".clans_request_assignment values (?, ?)");
			prepStmt.setInt(1, pInvitedPlayerID);
			prepStmt.setInt(2, pClan);
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public String getClanNameByID(int pClanID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement())
					.executeQuery("select clan_name from " + DATABASE + ".clan WHERE id='" + pClanID + "' LIMIT 1");
			if (rs.next())
				return rs.getString("clan_name");
			else {
				return null;
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return null;
	}

	public int getClanIDByName(String pClanName) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement())
					.executeQuery("select id from " + DATABASE + ".clan WHERE clan_name='" + pClanName + "' LIMIT 1");
			if (rs.next()) {
				return rs.getInt("id");
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return 0;
	}

	public void removeAllPlayersFromClan(int pClanID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("DELETE FROM " + DATABASE + ".clans_assignment WHERE clan_id='" + pClanID + "'");
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public void removeAllPlayersRequests(int pClanID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("DELETE FROM " + DATABASE + ".clans_request_assignment WHERE `clan_id`='" + pClanID + "'");
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public void removeClan(int pClanID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("DELETE FROM " + DATABASE + ".clan WHERE `id`='" + pClanID + "' LIMIT 1");
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public ArrayList<Integer> getMembersOfClan(int pClanID) {
		ArrayList<Integer> members = new ArrayList<>();
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery(
					"select player_id, type from " + DATABASE + ".clans_assignment WHERE clan_id='" + pClanID + "'");
			while (rs.next()) {
				if (rs.getByte("type") == 0)
					members.add(rs.getInt("player_id"));
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return members;
	}

	public ArrayList<Integer> getLeadersOfClan(int pClanID) {
		ArrayList<Integer> members = new ArrayList<>();
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery(
					"select player_id, type from " + DATABASE + ".clans_assignment WHERE clan_id='" + pClanID + "' AND type='1'");
			while (rs.next())
				members.add(rs.getInt("player_id"));
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return members;
	}

	public boolean isLeader(int pPlayerID, int pClanID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery("select type from " + DATABASE
					+ ".clans_assignment WHERE clan_id='" + pClanID + "' AND player_id='" + pPlayerID + "' LIMIT 1");
			if (rs.next())
				if (rs.getByte("type") == 1)
					return true;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return false;
	}

	public boolean isInClan(int pPlayerID, int pClanID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery("select player_id from " + DATABASE
					+ ".clans_assignment WHERE clan_id='" + pClanID + "' AND player_id='" + pPlayerID + "' LIMIT 1");
			if (rs.next())
				return true;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return false;
	}

	public ArrayList<Integer> getAllPlayersOfClan(int pClanID) {
		ArrayList<Integer> members = new ArrayList<>();
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery(
					"select player_id from " + DATABASE + ".clans_assignment WHERE clan_id='" + pClanID + "'");
			while (rs.next()) {
				members.add(rs.getInt("player_id"));
			}
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return members;
	}

	public boolean isClanEmpty(int pClanID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement()).executeQuery(
					"select player_id from " + DATABASE + ".clans_assignment WHERE clan_id='" + pClanID + "' LIMIT 1");
			if (rs.next())
				return false;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return true;
	}

	public void removeInvitation(int pPlayerID, int pClanID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("DELETE FROM " + DATABASE + ".clans_request_assignment WHERE player_id = '"
					+ pPlayerID + "' AND clan_id='" + pClanID + "'");
			prepStmt.execute();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public void setMemberType(int pPlayerID, int pClanID, int pType) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("UPDATE " + DATABASE + ".clans_assignment set type='" + pType
					+ "' WHERE clan_id='" + pClanID + "' AND player_id='" + pPlayerID + "' LIMIT 1");
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public void setClanName(String pNewClanName, int pClanID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("UPDATE " + DATABASE + ".clan set clan_name='" + pNewClanName
					+ "' WHERE id='" + pClanID + "' LIMIT 1");

			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public void setClanTag(String pNewClanTag, int pClanID) {
		Connection con = getConnection();
		PreparedStatement prepStmt = null;
		try {
			prepStmt = con.prepareStatement("UPDATE " + DATABASE + ".clan set clan_tag='" + pNewClanTag + "' WHERE id='"
					+ pClanID + "' LIMIT 1");
			prepStmt.executeUpdate();
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(prepStmt);
		}
	}

	public String getClanTag(int pClanID) {
		Connection con = getConnection();
		ResultSet rs = null;
		Statement stmt = null;
		try {
			rs = (stmt = con.createStatement())
					.executeQuery("select clan_tag from " + DATABASE + ".clan WHERE id='" + pClanID + "' LIMIT 1");
			if (rs.next())
				return rs.getString("clan_tag");
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
			close(rs, stmt);
		}
		return null;
	}

}