package de.simonsator.partyandfriends.clan;

import de.simonsator.partyandfriends.clan.clans.clansmanager.MySQLClansManager;
import de.simonsator.partyandfriends.clan.commands.CC;
import de.simonsator.partyandfriends.clan.commands.ClanCommands;
import de.simonsator.partyandfriends.clan.listener.OnJoin;
import de.simonsator.partyandfriends.clan.listener.SpigotCommunication;
import de.simonsator.partyandfriends.clan.utilities.ClanConfigLoader;
import de.simonsator.partyandfriends.clan.utilities.ClanMessagesLoader;
import de.simonsator.partyandfriends.main.Main;
import de.simonsator.partyandfriends.utilities.ConfigurationCreator;
import de.simonsator.partyandfriends.utilities.LanguageConfiguration;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;

import java.io.File;
import java.io.IOException;

public class ClansMain extends Plugin {
	private static ClansMain instance;
	private ClanConnection clanConnection;
	private ConfigurationCreator config;
	private LanguageConfiguration messages;
	private String clanPrefix;
	private ClanCommands clanCommands;

	public static ClansMain getInstance() {
		return instance;
	}

	public void onEnable() {
		try {
			if (!Main.getInstance().VALIDATION_KEY.equals("key:xzdnjfpdsofmuj:5554dfjkiue")) {
				sendLoadingError();
				return;
			}
		} catch (Exception e) {
			sendLoadingError();
			return;
		}
		instance = this;
		try {
			config = new ClanConfigLoader(new File(getDataFolder().getPath(), "config.yml"));
			messages = new ClanMessagesLoader(Main.getInstance().getLanguage(),
					new File(ClansMain.getInstance().getDataFolder().getPath(), "messages.yml"));
		} catch (IOException e) {
			e.printStackTrace();
		}
		clanConnection = (new ClanConnection(Main.getInstance().getConfig().getString("MySQL.Host"),
				Main.getInstance().getConfig().getString("MySQL.Username"),
				Main.getInstance().getConfig().getString("MySQL.Password"), Main.getInstance().getConfig().getInt("MySQL.Port"),
				Main.getInstance().getConfig().getString("MySQL.Database")));
		clanPrefix = getConfig().getString("General.ClanPrefix");
		new MySQLClansManager();
		registerCommands();
		registerListeners();
	}

	private void registerCommands() {
		clanCommands = new ClanCommands(getConfig().getStringList("General.Clan.Names"),
				getConfig().getString("General.Clan.Permissions"), clanPrefix);
		ProxyServer.getInstance().getPluginManager().registerCommand(this, getClanCommands());
		if (!getConfig().getString("Commands.CC.Deactivated").equalsIgnoreCase("true")) {
			ProxyServer.getInstance().getPluginManager().registerCommand(this,
					new CC(ClansMain.getInstance().getConfig().getStringList("General.CC.Names"),
							ClansMain.getInstance().getConfig().getString("General.Clan.Permissions")));
		}
	}

	private void sendLoadingError() {
		ProxyServer.getInstance().getConsole().sendMessage(
				new TextComponent("§cThe extended version of Party and Friends is needed inorder to use Clans"));
	}

	private void registerListeners() {
		ProxyServer.getInstance().getPluginManager().registerListener(this, new OnJoin());
		ProxyServer.getInstance().getPluginManager().registerListener(this, new SpigotCommunication());
	}

	public LanguageConfiguration getMessages() {
		return messages;
	}

	public ClanConnection getConnection() {
		return clanConnection;
	}

	public Configuration getConfig() {
		return config.getCreatedConfiguration();
	}

	public String getClanPrefix() {
		return clanPrefix;
	}

	public ClanCommands getClanCommands() {
		return clanCommands;
	}

	public void reload() throws IOException {
		messages.reloadConfiguration();
		config.reloadConfiguration();
	}
}