package de.simonsator.partyandfriends.clan.api;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.clan.api.events.ClanTagChangedEvent;
import de.simonsator.partyandfriends.clan.api.events.PlayerJointClanEvent;
import de.simonsator.partyandfriends.clan.api.events.PlayerLeftClanEvent;
import de.simonsator.partyandfriends.clan.api.events.PreClanDeleteEvent;
import de.simonsator.partyandfriends.main.Main;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.TextComponent;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Simonsator
 * @version 1.0.0 on 24.06.2016
 */
public abstract class Clan {
	public abstract List<PAFPlayer> getAllPlayers();

	public List<OnlinePAFPlayer> getAllOnlineClanPlayers() {
		List<OnlinePAFPlayer> list = new ArrayList<>();
		for (PAFPlayer member : getAllPlayers())
			if (member.isOnline())
				list.add((OnlinePAFPlayer) member);
		return list;
	}

	public abstract String getClanName();

	public abstract String getClanTag();

	public abstract boolean isLeader(PAFPlayer pPlayer);

	public abstract List<PAFPlayer> getLeaders();

	public abstract List<PAFPlayer> getMembers();

	public void sendMessage(TextComponent pTextComponent) {
		for (PAFPlayer player : getAllPlayers())
			player.sendMessage(pTextComponent);
	}

	public void acceptRequest(OnlinePAFPlayer pPlayer) {
		removeRequest(pPlayer);
		addToClan(pPlayer);
		ProxyServer.getInstance().getPluginManager().callEvent(new PlayerJointClanEvent(this, pPlayer));
	}

	public abstract void setClanName(String pNewName);

	public void setClanTag(String pNewTag) {
		ProxyServer.getInstance().getPluginManager().callEvent(new ClanTagChangedEvent(this));
	}

	protected abstract void addToClan(PAFPlayer pPlayer);

	public void deleteClan() {
		ProxyServer.getInstance().getPluginManager().callEvent(new PreClanDeleteEvent(this));
	}

	public abstract boolean contains(PAFPlayer pPlayer);

	public void removeFromClan(PAFPlayer pPlayer) {
		ProxyServer.getInstance().getPluginManager().callEvent(new PlayerLeftClanEvent(this, pPlayer));
	}

	public abstract void addLeader(PAFPlayer pPlayer);

	public abstract List<PAFPlayer> getInvitedPlayers();

	public abstract boolean isInvited(PAFPlayer pPlayer);

	public abstract void invite(PAFPlayer pPlayer);

	public abstract void removeLeader(PAFPlayer pPlayer);

	public abstract void removeRequest(PAFPlayer pPlayer);
}
