package de.simonsator.partyandfriends.clan.api.abstractcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.utilities.SubCommand;
import net.md_5.bungee.api.chat.TextComponent;

public abstract class ClanSubCommand extends SubCommand {
	public static final int LEADERS = 2;
	public static final int NO_CLAN = -1;
	public static final int HAS_CLAN = 1;

	public ClanSubCommand(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp, ClansMain.getInstance().getClanPrefix());
	}

	@Override
	protected void sendError(OnlinePAFPlayer pPlayer, String pIdentifier) {
		sendError(pPlayer, new TextComponent(ClansMain.getInstance().getClanPrefix()
				+ ClansMain.getInstance().getMessages().getString(pIdentifier)));
	}

	protected boolean enoughArguments(OnlinePAFPlayer pPlayer, String[] args, int n) {
		if (args.length < n) {
			sendError(pPlayer, "General.NotEnoughArguments");
			return false;
		}
		return true;
	}

	protected boolean enoughArguments(OnlinePAFPlayer pPlayer, String[] args) {
		return enoughArguments(pPlayer, args, 2);
	}

	protected Clan getClan(OnlinePAFPlayer pPlayer, String[] args) {
		Clan clan = ClansManager.getInstance().getClan(args[1]);
		if (clan == null) {
			sendError(pPlayer, "General.ClanNotFound");
			return null;
		}
		return clan;
	}

	protected Clan getClan(OnlinePAFPlayer pPlayer) {
		Clan clan = ClansManager.getInstance().getClan(pPlayer);
		if (clan == null) {
			pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
					+ ClansMain.getInstance().getMessages().getString("General.NoClan")));
			pPlayer.sendMessage(
					new TextComponent(ClansMain.getInstance().getMessages().getString("General.HowToCreateAClan")));
			return null;
		}
		return clan;
	}

	protected boolean isLeader(OnlinePAFPlayer pPlayer, Clan pClan) {
		if (!pClan.isLeader(pPlayer)) {
			sendError(pPlayer, "General.NotLeader");
			return false;
		}
		return true;
	}

	protected PAFPlayer getPlayer(OnlinePAFPlayer pPlayer, String[] args) {
		PAFPlayer player = PAFPlayerManager.getInstance().getPlayer(args[1]);
		if (!player.doesExist()) {
			sendError(pPlayer, "General.PlayerDoesNotExist");
			return null;
		}
		return player;
	}

	public boolean hasAccess(OnlinePAFPlayer pPlayer, int pPlayerType) {
		return true;
	}
}
