package de.simonsator.partyandfriends.clan.api.abstractcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.api.ClansManager;

/**
 * @author Simonsator
 * @version 1.0.0 on 01.08.16.
 */
public abstract class NoClanAcceptedCommands extends ClanSubCommand {
	public NoClanAcceptedCommands(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public boolean hasAccess(OnlinePAFPlayer pPlayer, int pPlayerType) {
		return pPlayerType == -1;
	}

	protected boolean isInAClan(OnlinePAFPlayer pPlayer) {
		if (ClansManager.getInstance().getClan(pPlayer) != null) {
			sendError(pPlayer, "General.ClanFound");
			return true;
		}
		return false;
	}

}
