package de.simonsator.partyandfriends.clan.api.abstractcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;

/**
 * @author Simonsator
 * @version 1.0.0 on 01.08.16.
 */
public abstract class RenameClanCommands extends NoClanAcceptedCommands {
	public RenameClanCommands(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	protected boolean isNameToLong(OnlinePAFPlayer pPlayer, String pName) {
		if (pName.length() > 16) {
			sendError(pPlayer, "General.NameTooLong");
			return true;
		}
		return false;
	}

	protected boolean isTagToLong(OnlinePAFPlayer pPlayer, String pTag) {
		if (pTag.length() > 4) {
			sendError(pPlayer, "General.TagTooLong");
			return true;
		}
		return false;
	}

	@Override
	public boolean hasAccess(OnlinePAFPlayer pPlayer, int pPlayerType) {
		return pPlayerType == ClanSubCommand.LEADERS;
	}

}
