package de.simonsator.partyandfriends.clan.clans.clan;

import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.pafplayers.manager.PAFPlayerManagerMySQL;
import de.simonsator.partyandfriends.pafplayers.mysql.PAFPlayerMySQL;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Simonsator
 * @version 1.0.0 on 24.06.2016
 */
public class MySQLClan extends Clan {
	private final int CLAN_ID;

	public MySQLClan(int pClanID) {
		CLAN_ID = pClanID;
	}

	@Override
	public List<PAFPlayer> getAllPlayers() {
		return toPAFPlayerList(ClansMain.getInstance().getConnection().getAllPlayersOfClan(CLAN_ID));
	}

	@Override
	public String getClanName() {
		return ClansMain.getInstance().getConnection().getClanNameByID(CLAN_ID);
	}

	@Override
	public String getClanTag() {
		return ClansMain.getInstance().getConnection().getClanTag(CLAN_ID);
	}

	@Override
	public boolean isLeader(PAFPlayer pPlayer) {
		return ClansMain.getInstance().getConnection().isLeader(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), CLAN_ID);
	}

	@Override
	public List<PAFPlayer> getLeaders() {
		return toPAFPlayerList(ClansMain.getInstance().getConnection().getLeadersOfClan(CLAN_ID));
	}

	@Override
	public List<PAFPlayer> getMembers() {
		return toPAFPlayerList(ClansMain.getInstance().getConnection().getMembersOfClan(CLAN_ID));
	}

	@Override
	public void setClanName(String pNewName) {
		ClansMain.getInstance().getConnection().setClanName(pNewName, CLAN_ID);
	}

	@Override
	public void setClanTag(String pNewTag) {
		super.setClanTag(pNewTag);
		ClansMain.getInstance().getConnection().setClanTag(pNewTag, CLAN_ID);
	}

	@Override
	protected void addToClan(PAFPlayer pPlayer) {
		ClansMain.getInstance().getConnection().setClan(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), CLAN_ID, (byte) 0);
	}

	@Override
	public void deleteClan() {
		super.deleteClan();
		ClansMain.getInstance().getConnection().removeAllPlayersFromClan(CLAN_ID);
		ClansMain.getInstance().getConnection().removeAllPlayersRequests(CLAN_ID);
		ClansMain.getInstance().getConnection().removeClan(CLAN_ID);
	}

	@Override
	public boolean contains(PAFPlayer pPlayer) {
		return ClansMain.getInstance().getConnection().isInClan(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), CLAN_ID);
	}

	@Override
	public void removeFromClan(PAFPlayer pPlayer) {
		List<PAFPlayer> members = getAllPlayers();
		removeLeader(pPlayer);
		ClansMain.getInstance().getConnection().removeClanAssignment(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), CLAN_ID);
		if (ClansMain.getInstance().getConnection().isClanEmpty(CLAN_ID))
			deleteClan();
		else {
			if (getLeaders().isEmpty())
				addLeader(members.get(0));
		}
		super.removeFromClan(pPlayer);
	}

	@Override
	public void addLeader(PAFPlayer pPlayer) {
		ClansMain.getInstance().getConnection().setMemberType(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), CLAN_ID, 1);
	}

	@Override
	public List<PAFPlayer> getInvitedPlayers() {
		return toPAFPlayerList(ClansMain.getInstance().getConnection().getRequestedPlayers(CLAN_ID));
	}

	@Override
	public boolean isInvited(PAFPlayer pPlayer) {
		return ClansMain.getInstance().getConnection().isInvited(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), getClanID());
	}

	@Override
	public void invite(PAFPlayer pPlayer) {
		ClansMain.getInstance().getConnection().inviteIntoClan(getClanID(), ((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID());
	}

	@Override
	public void removeLeader(PAFPlayer pPlayer) {
		ClansMain.getInstance().getConnection().setMemberType(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), CLAN_ID, 0);
	}

	@Override
	public void removeRequest(PAFPlayer pPlayer) {
		ClansMain.getInstance().getConnection().removeInvitation(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID(), CLAN_ID);
	}

	private List<PAFPlayer> toPAFPlayerList(List<Integer> list) {
		List<PAFPlayer> list2 = new ArrayList<>();
		for (int id : list)
			list2.add(((PAFPlayerManagerMySQL) PAFPlayerManager.getInstance()).getPlayer(id));
		return list2;
	}

	private int getClanID() {
		return CLAN_ID;
	}
}
