package de.simonsator.partyandfriends.clan.clans.clansmanager;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.clan.ClanConnection;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClanPlayer;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.events.PlayerJointClanEvent;
import de.simonsator.partyandfriends.clan.clans.clan.MySQLClan;
import de.simonsator.partyandfriends.clan.clans.clanplayers.MySQLClanPlayer;
import de.simonsator.partyandfriends.pafplayers.mysql.PAFPlayerMySQL;
import net.md_5.bungee.api.ProxyServer;

/**
 * @author Simonsator
 * @version 1.0.0 on 31.07.16.
 */
public class MySQLClansManager extends ClansManager {
	private final ClanConnection con = ClansMain.getInstance().getConnection();

	public MySQLClansManager() {
		super();
	}

	@Override
	public Clan getClan(PAFPlayer pPlayer) {
		int clanID = con.getClanByID(((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID());
		if (clanID == 0)
			return null;
		return new MySQLClan(clanID);
	}

	@Override
	public Clan getClan(String pName) {
		return getClan(ClansMain.getInstance().getConnection().getClanIDByName(pName));
	}

	@Override
	public void createClan(OnlinePAFPlayer pPlayer, String pClanName, String pClanTag) {
		Clan clan = getClan(con.createClan((((PAFPlayerMySQL) pPlayer.getPAFPlayer()).getPlayerID()), pClanName, pClanTag));
		if (clan != null)
			ProxyServer.getInstance().getPluginManager().callEvent(new PlayerJointClanEvent(clan, pPlayer));
	}

	@Override
	public ClanPlayer getClanPlayer(PAFPlayer pPlayer) {
		return new MySQLClanPlayer(pPlayer);
	}

	public Clan getClan(int pClanID) {
		if (pClanID != 0)
			return new MySQLClan(pClanID);
		return null;
	}
}
