package de.simonsator.partyandfriends.clan.commands;

import de.simonsator.partyandfriends.api.TopCommand;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanSubCommand;
import de.simonsator.partyandfriends.clan.commands.subcommands.*;
import net.md_5.bungee.api.chat.TextComponent;

import java.util.List;

public class ClanCommands extends TopCommand<ClanSubCommand> {
	private static ClanCommands instance;

	public ClanCommands(List<String> pNames, String pPermission, String pPrefix) {
		super(pNames.toArray(new String[0]), pPermission, pPrefix);
		instance = this;
		if (ClansMain.getInstance().getConfig().getString("Commands.Chat.Deactivated").equalsIgnoreCase("false"))
			addCommand(new Chat(
					(ClansMain.getInstance().getConfig().getStringList("Commands.Chat.Names")).toArray(new String[0]),
					ClansMain.getInstance().getMessages().getString("CommandUsage.Chat")));
		String[] joinCommandNames = ClansMain.getInstance().getConfig().getStringList("Commands.Join.Names").toArray(new String[0]);
		addCommand(new Join(
				joinCommandNames, 2,
				ClansMain.getInstance().getMessages().getString("CommandUsage.Join")));
		addCommand(new Invite(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Invite.Names")).toArray(new String[0]),
				3, ClansMain.getInstance().getMessages().getString("CommandUsage.Invite"), joinCommandNames[0]));
		addCommand(new Create(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Create.Names")).toArray(new String[0]),
				1, ClansMain.getInstance().getMessages().getString("CommandUsage.Create")));
		addCommand(new Leave(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Leave.Names")).toArray(new String[0]),
				19, ClansMain.getInstance().getMessages().getString("CommandUsage.Leave")));
		addCommand(new Decline(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Decline.Names")).toArray(new String[0]),
				11, ClansMain.getInstance().getMessages().getString("CommandUsage.Decline")));
		addCommand(new Delete(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Delete.Names")).toArray(new String[0]),
				7, ClansMain.getInstance().getMessages().getString("CommandUsage.Delete")));
		if (ClansMain.getInstance().getConfig().getString("Commands.Get.Deactivated").equalsIgnoreCase("false"))
			addCommand(new Get(
					(ClansMain.getInstance().getConfig().getStringList("Commands.Get.Names")).toArray(new String[0]),
					15, ClansMain.getInstance().getMessages().getString("CommandUsage.Get")));
		addCommand(new Info(
				(ClansMain.getInstance().getConfig().getStringList("Commands.List.Names")).toArray(new String[0]), 16,
				ClansMain.getInstance().getMessages().getString("CommandUsage.List")));
		addCommand(new Party(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Party.Names")).toArray(new String[0]),
				12, ClansMain.getInstance().getMessages().getString("CommandUsage.Party")));
		addCommand(new Kick(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Kick.Names")).toArray(new String[0]), 5,
				ClansMain.getInstance().getMessages().getString("CommandUsage.Kick")));
		addCommand(new Leader(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Leader.Names")).toArray(new String[0]),
				4, ClansMain.getInstance().getMessages().getString("CommandUsage.Leader")));
		addCommand(new Name(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Name.Names")).toArray(new String[0]), 6,
				ClansMain.getInstance().getMessages().getString("CommandUsage.Name")));
		addCommand(new Settings(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Settings.Names")).toArray(new String[0]),
				20, ClansMain.getInstance().getMessages().getString("CommandUsage.Settings")));
		if (ClansMain.getInstance().getConfig().getString("Commands.Stats.Deactivated").equalsIgnoreCase("false"))
			addCommand(new Stats(
					(ClansMain.getInstance().getConfig().getStringList("Commands.Stats.Names"))
							.toArray(new String[0]),
					17, ClansMain.getInstance().getMessages().getString("CommandUsage.Stats")));
		addCommand(new Tag(
				(ClansMain.getInstance().getConfig().getStringList("Commands.Tag.Names")).toArray(new String[0]), 8,
				ClansMain.getInstance().getMessages().getString("CommandUsage.Tag")));
	}


	@Override
	protected void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		int playerType = ClanSubCommand.NO_CLAN;
		Clan clan = ClansManager.getInstance().getClan(pPlayer);
		if (clan != null)
			if (clan.isLeader(pPlayer))
				playerType = ClanSubCommand.LEADERS;
			else
				playerType = ClanSubCommand.HAS_CLAN;
		if (args.length == 0) {
			pPlayer.sendMessage(
					new TextComponent(ClansMain.getInstance().getMessages().getString("General.HelpHeader")));
			for (ClanSubCommand command : subCommands)
				if (command.hasAccess(pPlayer, playerType))
					pPlayer.sendMessage(new TextComponent(command.HELP));
			pPlayer.sendMessage(
					new TextComponent(ClansMain.getInstance().getMessages().getString("General.HelpEnd")));
			return;
		}
		for (ClanSubCommand command : subCommands)
			if (command.isApplicable(args[0])) {
				command.onCommand(pPlayer, args);
				return;
			}
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
				+ ClansMain.getInstance().getMessages().getString("General.CommandNotFound")));
	}

	public static ClanCommands getInstance() {
		return instance;
	}
}
