package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanMemberCommand;
import net.md_5.bungee.api.chat.TextComponent;

public class Chat extends ClanMemberCommand {
	public Chat(String[] pCommands, String pHelp) {
		super(pCommands, 13, pHelp);
	}

	public void writeToPlayer(OnlinePAFPlayer pPlayer, String[] args, int start) {
		if (args.length < start + 1) {
			pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
					+ ClansMain.getInstance().getMessages().getString("General.NotEnoughArguments")));
			pPlayer.sendMessage(
					new TextComponent(ClansMain.getInstance().getMessages().getString("CommandUsage.Chat")));
			return;
		}
		Clan clan = ClansManager.getInstance().getClan(pPlayer);
		if (clan == null) {
			pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
					+ ClansMain.getInstance().getMessages().getString("General.NoClan")));
			pPlayer.sendMessage(
					new TextComponent(ClansMain.getInstance().getMessages().getString("General.HowToCreateAClan")));
			return;
		}
		String message = "";
		while (start < args.length) {
			message = message + ClansMain.getInstance().getMessages().getString("Chat.Color") + args[start];
			start++;
		}
		message = ClansMain.getInstance().getMessages().getString("Chat.Send").replace("[MESSAGE]", message)
				.replace("[SENDER]", pPlayer.getName());

		clan.sendMessage(new TextComponent(ClansMain.getInstance().getMessages().getString("Chat.ChatPrefix") + message));
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		writeToPlayer(pPlayer, args, 1);
	}
}
