package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.abstractcommands.RenameClanCommands;
import net.md_5.bungee.api.chat.TextComponent;

public class Create extends RenameClanCommands {
	public Create(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		if (!enoughArguments(pPlayer, args, 3))
			return;
		if (isNameToLong(pPlayer, args[1]))
			return;
		if (isTagToLong(pPlayer, args[2]))
			return;
		if (isInAClan(pPlayer))
			return;
		if (ClansManager.getInstance().getClan(args[1]) != null) {
			pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance()
					.getMessages().getString("Create.ClanExistsAlready").replace("[CLANNAME]", args[1])));
			pPlayer.sendMessage(HELP);
			return;
		}
		ClansManager.getInstance().createClan(pPlayer, args[1], args[2]);
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
				+ ClansMain.getInstance().getMessages().getString("Create.Created")));
	}

	@Override
	public boolean hasAccess(OnlinePAFPlayer pPlayer, int pPlayerType) {
		return pPlayerType == -1;
	}
}
