package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanSubCommand;
import net.md_5.bungee.api.chat.TextComponent;

public class Decline extends ClanSubCommand {
	public Decline(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public boolean hasAccess(OnlinePAFPlayer pPlayer, int pPlayerType) {
		return !ClansMain.getInstance().getConnection().getRequests(pPlayerType).isEmpty();
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		if (!enoughArguments(pPlayer, args))
			return;
		Clan clan = getClan(pPlayer, args);
		if (clan == null)
			return;
		if (!clan.isInvited(pPlayer)) {
			sendError(pPlayer, "General.NotInvited");
			return;
		}
		clan.removeRequest(pPlayer);
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
				+ ClansMain.getInstance().getMessages().getString("Decline.Declined")));
	}

}
