package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanSubCommand;
import net.md_5.bungee.api.chat.TextComponent;

public class Info extends ClanSubCommand {
	public Info(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		Clan clan;
		if (args.length == 1)
			clan = getClan(pPlayer);
		else
			clan = getClan(pPlayer, args);
		if (clan == null)
			return;
		output(pPlayer, clan);
	}

	private void output(OnlinePAFPlayer player, Clan pClan) {
		player.sendMessage(new TextComponent(ClansMain.getInstance().getMessages().getString("Info.ClanHeader")
				.replace("[CLANNAME]", pClan.getClanName())));
		String leaderNames = "";
		for (PAFPlayer leader : pClan.getLeaders()) {
			if (leaderNames.equals("")) {
				leaderNames = leader.getDisplayName();
			} else {
				leaderNames = leaderNames + ClansMain.getInstance().getMessages().getString("Info.LeadersCut")
						+ leader.getDisplayName();
			}
		}
		player.sendMessage(
				new TextComponent(ClansMain.getInstance().getMessages().getString("Info.ClanLeaders") + leaderNames));
		String playerInsideClanNames = "";
		for (PAFPlayer members : pClan.getMembers()) {
			if (playerInsideClanNames.equals("")) {
				playerInsideClanNames = members.getDisplayName();
			} else {
				playerInsideClanNames = playerInsideClanNames
						+ ClansMain.getInstance().getMessages().getString("Info.PlayersCut")
						+ members.getDisplayName();
			}
		}
		if (playerInsideClanNames.equals("")) {
			playerInsideClanNames = ClansMain.getInstance().getMessages().getString("Info.Empty");
		}
		player.sendMessage(new TextComponent(
				ClansMain.getInstance().getMessages().getString("Info.Players") + playerInsideClanNames));
		player.sendMessage(new TextComponent(ClansMain.getInstance().getMessages().getString("Info.ClanFooter")));
	}

}
