package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanLeaderCommand;
import de.simonsator.partyandfriends.clan.commands.ClanCommands;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.protocol.packet.Chat;

public class Invite extends ClanLeaderCommand {
	private final String JOIN_COMMAND_NAME;

	public Invite(String[] pCommands, int pPriority, String pHelp, String pJoinCommandName) {
		super(pCommands, pPriority, pHelp);
		this.JOIN_COMMAND_NAME = "/" + ClanCommands.getInstance().getName() + " " + pJoinCommandName + " ";
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		if (!enoughArguments(pPlayer, args))
			return;
		if (pPlayer.getName().equalsIgnoreCase(args[1])) {
			sendError(pPlayer, "Invite.InvitedHimSelf");
			return;
		}
		Clan clan = getClan(pPlayer);
		if (clan == null)
			return;
		if (!isLeader(pPlayer, clan))
			return;
		PAFPlayer invited = getPlayer(pPlayer, args);
		if (invited == null)
			return;
		if (clan.isInvited(pPlayer)) {
			sendError(pPlayer, new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance()
					.getMessages().getString("Invite.AlreadyInvited").replace("[PLAYER]", args[1])));
			return;
		}
		switch (pPlayer.getSettingsWorth(10)) {
			case 1:
				if (!pPlayer.isAFriendOf(invited)) {
					sendCanNotInviteError(pPlayer);
					break;
				}
			case 2:
				sendCanNotInviteError(pPlayer);
				break;
			default:
				if (ClansManager.getInstance().getClan(invited) != null) {
					sendCanNotInviteError(pPlayer);
					return;
				}
				clan.invite(invited);
				pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getMessages().
						getString("Invite.PlayerWasInvited").replace("[PLAYER]", invited.getDisplayName())));
				String clanName = clan.getClanName();
				invited.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance()
						.getMessages().getString("Invite.YouWereInvited").replace("[CLANNAME]", clanName)));
				invited.sendPacket(new Chat("{\"text\":\"" + ClansMain.getInstance().getMessages().getString("Invite.AcceptBy").replace("[CLANNAME]",
						clanName)
						+ "\",\"clickEvent\":{\"action\":\"run_command\",\"value\":\"" + JOIN_COMMAND_NAME + clanName
						+ "\"},\"hoverEvent\":{\"action\":\"show_text\",\"value\":{\"text\":\"\",\"extra\":[{\"text\":\""
						+ ClansMain.getInstance().getMessages().getString("Invite.Hover") + "\"}]}}}"));
				break;
		}
	}

	private void sendCanNotInviteError(OnlinePAFPlayer pPlayer) {
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
				+ ClansMain.getInstance().getMessages().getString("Invite.CanNotInviteThisPerson")));
	}
}
