package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanSubCommand;
import de.simonsator.partyandfriends.clan.api.abstractcommands.NoClanAcceptedCommands;
import net.md_5.bungee.api.chat.TextComponent;

public class Join extends NoClanAcceptedCommands {

	public Join(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		if (!enoughArguments(pPlayer, args))
			return;
		if (!enoughArguments(pPlayer, args, 2))
			return;
		if (isInAClan(pPlayer))
			return;
		Clan clan = getClan(pPlayer, args);
		if (clan == null) {
			sendError(pPlayer, "General.ClanDoesNotExist");
			return;
		}
		if (!clan.isInvited(pPlayer)) {
			sendError(pPlayer, "General.NotInvited");
			return;
		}
		clan.acceptRequest(pPlayer);
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
				+ ClansMain.getInstance().getMessages().getString("Join.JoinedClan").replace("[CLAN]", args[1])));
	}

	@Override
	public boolean hasAccess(OnlinePAFPlayer pPlayer, int pPlayerType) {
		return pPlayerType == ClanSubCommand.NO_CLAN
				&& ClansManager.getInstance().getClanPlayer(pPlayer).hasInvitations();
	}

}
