package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanLeaderCommand;
import net.md_5.bungee.api.chat.TextComponent;

public class Kick extends ClanLeaderCommand {
	public Kick(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		if (!enoughArguments(pPlayer, args))
			return;
		if (pPlayer.getName().equalsIgnoreCase(args[1])) {
			sendError(pPlayer, "Kick.KickHimSelf");
			return;
		}
		Clan clan = getClan(pPlayer);
		if (clan == null)
			return;
		if (!isLeader(pPlayer, clan))
			return;
		PAFPlayer toKick = PAFPlayerManager.getInstance().getPlayer(args[1]);
		if (!toKick.doesExist() | !clan.contains(toKick)) {
			sendError(pPlayer, "General.NotInTheClan");
			return;
		}
		if (clan.isLeader(toKick)) {
			sendError(pPlayer, "Kick.KickLeader");
			return;
		}
		clan.removeFromClan(toKick);
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
				+ ClansMain.getInstance().getMessages().getString("Kick.PlayerKicked")));
	}
}
