package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanMemberCommand;
import de.simonsator.partyandfriends.party.subcommand.*;
import de.simonsator.partyandfriends.utilities.SubCommand;
import net.md_5.bungee.api.chat.TextComponent;

import static de.simonsator.partyandfriends.main.Main.*;

public class Party extends ClanMemberCommand {
	private final SubCommand INVITE_COMMAND =
			getInstance().getPartyCommand().getSubCommand(de.simonsator.partyandfriends.party.subcommand.Invite.class);

	public Party(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		Clan clan = getClan(pPlayer);
		if (clan == null)
			return;
		int playersInvited = 0;
		String[] invitation = new String[1];
		for (PAFPlayer player : clan.getAllOnlineClanPlayers())
			if (!player.equals(pPlayer))
				if (player.getSettingsWorth(1) == 0 || player.isAFriendOf(pPlayer)) {
					invitation[0] = player.getName();
					INVITE_COMMAND.onCommand(pPlayer, invitation);
					playersInvited++;
				}
		if (playersInvited == 0)
			pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix()
					+ ClansMain.getInstance().getMessages().getString("Party.Empty")));
	}

}
