package de.simonsator.partyandfriends.clan.commands.subcommands;

import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClanStats;
import de.simonsator.partyandfriends.clan.api.abstractcommands.ClanSubCommand;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.plugin.Plugin;

import java.util.ArrayList;
import java.util.List;

public class Stats extends ClanSubCommand {
	private final List<Stats_Info> CLAN_STATS = new ArrayList<>();

	public Stats(String[] pCommands, int pPriority, String pHelp) {
		super(pCommands, pPriority, pHelp);
	}

	@Override
	public void onCommand(OnlinePAFPlayer pPlayer, String[] args) {
		if (CLAN_STATS.isEmpty()) {
			pPlayer.sendMessage("&cYou need to install a plugin that supports clan stats to see the stats of a clan in a minigame." +
					" If you don't want to install any, disable this command in the config.");
			return;
		}
		Clan clan;
		if (args.length == 1)
			clan = getClan(pPlayer);
		else
			clan = getClan(pPlayer, args);
		if (clan == null)
			return;
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getMessages().getString("Stats.Begin").replace("[CLANNAME]",
				clan.getClanName())));
		for (Stats_Info stats_info : CLAN_STATS)
			stats_info.CLAN_STATS.stats(pPlayer, clan);
		pPlayer.sendMessage(new TextComponent(ClansMain.getInstance().getMessages().getString("Stats.End")));
	}

	public void registerClanStats(ClanStats pStats, Plugin pPlugin) {
		CLAN_STATS.add(new Stats_Info(pStats, pPlugin));
	}

	public void unregisterAll(Plugin pPlugin) {
		if (CLAN_STATS.remove(new Stats_Info(null, pPlugin)))
			unregisterAll(pPlugin);
	}

	private class Stats_Info {
		private final ClanStats CLAN_STATS;
		private final Plugin PLUGIN;

		private Stats_Info(ClanStats pClanStats, Plugin pPlugin) {
			CLAN_STATS = pClanStats;
			PLUGIN = pPlugin;
		}

		public boolean equals(Stats_Info pObject) {
			return pObject.PLUGIN.equals(this.PLUGIN);
		}
	}
}
