package de.simonsator.partyandfriends.clan.listener;

import de.simonsator.partyandfriends.api.pafplayers.PAFPlayer;
import de.simonsator.partyandfriends.api.pafplayers.PAFPlayerManager;
import de.simonsator.partyandfriends.clan.ClansMain;
import de.simonsator.partyandfriends.clan.api.Clan;
import de.simonsator.partyandfriends.clan.api.ClanPlayer;
import de.simonsator.partyandfriends.clan.api.ClansManager;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;
import net.md_5.bungee.event.EventPriority;

import java.util.List;

public class OnJoin implements Listener {
	@EventHandler(priority = EventPriority.LOW)
	public void onPostLogin(final PostLoginEvent pEvent) {
		ClansMain.getInstance().getProxy().getScheduler().runAsync(ClansMain.getInstance(), new Runnable() {
			@Override
			public void run() {
				somebodyLoggedIn(pEvent);
			}
		});

	}

	public void somebodyLoggedIn(PostLoginEvent pEvent) {
		PAFPlayer player = PAFPlayerManager.getInstance().getPlayer(pEvent.getPlayer());
		if (!player.doesExist())
			return;
		ClanPlayer clanPlayer = ClansManager.getInstance().getClanPlayer(player);
		List<Clan> clansInvitedTo = clanPlayer.getClanRequests();
		if (!clansInvitedTo.isEmpty()) {
			String output = ClansMain.getInstance().getMessages()
					.getString("General.OnJoin.OpenInvitations");
			output = output + clansInvitedTo.get(0).getClanName();
			for (int i = 1; i < clansInvitedTo.size(); i++) {
				output = output + ClansMain.getInstance().getMessages().getString("General.OnJoin.Splitter")
						+ clansInvitedTo.get(i).getClanName();
			}
			player.sendMessage(new TextComponent(ClansMain.getInstance().getClanPrefix() + output));
			player.sendMessage(ClansMain.getInstance().getClanPrefix() + ClansMain.getInstance().getConfig().getString("General.OnJoin.HowToAccept"));
		}
	}
}
