package de.simonsator.partyandfriends.clan.listener;

import com.google.gson.JsonObject;
import de.simonsator.partyandfriends.api.pafplayers.OnlinePAFPlayer;
import de.simonsator.partyandfriends.clan.api.events.ClanTagChangedEvent;
import de.simonsator.partyandfriends.clan.api.events.PlayerJointClanEvent;
import de.simonsator.partyandfriends.clan.api.events.PlayerLeftClanEvent;
import de.simonsator.partyandfriends.communication.communicationtasks.SpigotCommunicationTask;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.event.EventHandler;

/**
 * @author simonbrungs
 * @version 1.0.0 10.11.16
 */
public class SpigotCommunication extends SpigotCommunicationTask implements Listener {
	public SpigotCommunication() {
		super("InformAboutClanTagChange");
	}

	@EventHandler
	public void informAboutClanJoin(PlayerJointClanEvent pEvent) {
		JsonObject toSend = new JsonObject();
		toSend.addProperty("task", "InformAboutNewClan");
		sendMessage(toSend, pEvent.getPlayer());
	}

	@EventHandler
	public void informAboutClanLeave(PlayerLeftClanEvent pEvent) {
		if (pEvent.getPlayer().isOnline()) {
			JsonObject toSend = new JsonObject();
			toSend.addProperty("task", "InformAboutClanLeave");
			sendMessage(toSend, (OnlinePAFPlayer) pEvent.getPlayer());
		}
	}

	@EventHandler
	public void informAboutClanTagChange(ClanTagChangedEvent pEvent) {
		JsonObject toSend = new JsonObject();
		toSend.addProperty("task", "InformAboutClanTagChange");
		for (OnlinePAFPlayer player : pEvent.getClan().getAllOnlineClanPlayers())
			sendMessage(toSend, player);
	}
}
