package de.simonsator.partyandfriends.clan.utilities;

import de.simonsator.partyandfriends.utilities.ConfigLoader;
import de.simonsator.partyandfriends.utilities.ConfigurationCreator;

import java.io.File;
import java.io.IOException;

/**
 * @author Simonsator
 * @version 1.0.0 on 02.08.16.
 */
public class ClanConfigLoader extends ConfigurationCreator {
	public ClanConfigLoader(File file) throws IOException {
		super(file);
		readFile();
		loadDefaultValues();
		saveFile();
		process(configuration);
	}

	private void loadDefaultValues() {
		set("General.LanguageName", "english");
		set("General.ClanPrefix", "&8[&5Clan&8]&r&7 ");
		set("General.Clan.Names", "clan", "clans");
		set("General.Clan.Permissions", "");
		set("General.CC.Names", "cc", "clanchat");
		set("General.CC.Deactivated", "false");
		set("Commands.Chat.Names", "chat", "msg");
		set("Commands.Chat.Deactivated", "false");
		set("Commands.Create.Names", "create", "make");
		set("Commands.Delete.Names", "delete", "remove");
		set("Commands.Decline.Names", "decline", "reject", "deny");
		set("Commands.Get.Names", "get", "getclanof");
		set("Commands.Get.Deactivated", "false");
		set("Commands.Invite.Names", "invite", "ask");
		set("Commands.Kick.Names", "kick", "kickplayer");
		set("Commands.Leader.Names", "leader", "promote");
		set("Commands.List.Names", "list", "info");
		set("Commands.Join.Names", "join", "enter");
		set("Commands.Leave.Names", "leave", "exit");
		set("Commands.Name.Names", "name", "rename");
		set("Commands.Party.Names", "party", "partyinvite");
		set("Commands.Settings.Names", "setting", "settings");
		set("Commands.Stats.Names", "stats", "stat");
		set("Commands.Stats.Deactivated", "false");
		set("Commands.Tag.Names", "tag", "retag");
	}

	@Override
	public void reloadConfiguration() throws IOException {
		configuration = (new ConfigLoader(FILE)).getCreatedConfiguration();
	}
}
